/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This is the code that creates a calculator window in the data base.  It
 * contains a table with two rows and one column.  The user can type an
 * expression in the top row.  The result is printed in the bottom row.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

#define WIDTH		900
#define HEIGHT		100

extern char *mag_new(), *pic_new();

calc_init(){
	char *wid;

	mag_picture("calc.win", "calc", "calc", WIDTH, HEIGHT, 0);

	db_store("calc.value", "text", "#calc.expr text # $eval");
	mag_append("calc.tab", "calc.expr", 0);
	mag_append("calc.tab", "calc.value", 0);
	wid = pic_new("calc", "table", "calc.tab",
					10, 10, WIDTH - 20, 60, 1, 1);
	tbl_column(wid, "text", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
}
