/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This is the code for the history bar.  If you push Button1 somewhere in
 * this bar, the time is frozen and the new time is set relative to the
 * place in the bar.  At the bottom there is a thing to unfreeze time.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

extern db_seq;

int bar_start, bar_hist, bar_seq;

/* This routine is called when the history bar is selected.
 */
bar_press(o, x, y, key, count)
struct object *o;
{
	int height = o->o_height - o->o_width;

	if (y >= height)	/* continue normal operation */
		bar_hist = bar_seq = 0;
	else if (count == 1) {	/* set history */
		if (bar_hist == 0)
			bar_hist = db_seq;
		bar_seq = bar_start + y * (bar_hist - bar_start) / height;
	}
	else {
		/* First cut at setting the start of history.  Needs more
		 * thought though.
		 */
		bar_start = bar_seq;
	}
}

/* Follow the mouse pointer.
 */
bar_track(o, x, y)
struct object *o;
{
	int height = o->o_height - o->o_width;

	if (bar_hist == 0)
		return;
	if (y >= height)
		bar_seq = bar_hist;
	else
		bar_seq = bar_start + y * (bar_hist - bar_start) / height;
}

/* Draw the history bar.
 */
bar_draw(w, o)
struct window *w;
struct object *o;
{
	int y = o->o_y, height = o->o_height - o->o_width;

	win_line(w, o->o_x, y + height, o->o_x + o->o_width, y + height);
	if (bar_start == 0)
		bar_start = db_seq;
	if (bar_hist != 0 && bar_hist != bar_start) {
		y += (bar_seq - bar_start) * height / (bar_hist - bar_start);
		win_line(w, o->o_x, y, o->o_x + o->o_width, y);
	}
}
