/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

extern char *mag_alloc(), *mag_malloc(), *mag_copy();

/* Some handy definitions.
 */
#define m_min(a, b)	((a) < (b) ? (a) : (b))
#define m_max(a, b)	((a) > (b) ? (a) : (b))
#define m_abs(a)	((a) < 0 ? -(a) : (a))

/* Scmp compares two strings for equality.  Check the first characters
 * separately for efficiency.
 */
#define scmp(a, b)	(*(a) == *(b) && strcmp((a), (b)) == 0)

/* Memory is allocate by either MAG_MALLOC or MAG_ALLOC.  MAG_ALLOC is
 * the same as MAG_MALLOC, but clears memory first.  Both get two arguments:
 * the second is the type, and the first is the number of structures that
 * should be allocated of that type.
 */

#ifdef MAG_DEBUG

#define MAG_MALLOC(n, t)	((t *) mag_malloc((n), (n) * sizeof(t), "t"))
#define MAG_ALLOC(n, t)	((t *) mag_alloc((n), (n) * sizeof(t), "t"))

#else

#define MAG_MALLOC(n, t)	((t *) mag_malloc((n) * sizeof(t)))
#define MAG_ALLOC(n, t)	((t *) mag_alloc((n) * sizeof(t)))

#endif

#define MAG_FREE(p)		mag_free((char *) (p))
