/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"
#include "value.h"

struct value **mes_ok(), **mes_alloc(), *mag_index(), *db_get();

struct value **fac_map(mes)
struct value **mes;
{
	if (!val_null(mes[4]))
		mag_store(mes[2], "widget", "mapped", mes[4]);
	return mes_ok();
}

struct value **fac_switch(mes)
struct value **mes;
{
	if (!val_null(mes[4]))
		mag_store(mes[2], "onoff", "value", mes[4]);
	return mes_ok();
}

struct value **fac_copy(mes)
struct value **mes;
{
	db_put(val_str(mes[0]), val_str(mes[3]), mes[4]);
	return mes_ok();
}

struct value **fac_offtrap(mes)
struct value **mes;
{
	if (val_int(mes[4]))
		db_numstore(val_str(mes[2]), "on/off", 0);
	return mes_ok();
}

struct value **fac_ontrap(mes)
struct value **mes;
{
	if (val_int(mes[4]))
		db_numstore(val_str(mes[2]), "on/off", 1);
	return mes_ok();
}

/* Send a message to station to put a watch on attr.
 */
fac_subscribe(station, attr)
struct value *station;
char *attr;
{
	extern mag_reply();
	struct value **mes = mes_alloc(5);

	mes[1] = val_sstr("watch", 0);
	mes[2] = val_sstr("fac_copy", 0);
	mes[3] = val_sstr("machine", 0);
	mes[4] = val_sstr(attr, 0);
	mes_send_request(val_ref(station), mes, mag_reply);
}

struct value **fac_machinit(mes)
struct value **mes;
{
	char *mach = mag_copy(val_str(mes[0]));

	watch_specify(V_NULL, "fac_switch", mach, "on/off");
	watch_specify(V_NULL, "fac_map", mach, "mapped");
	if (*mach == 'm') {
		fac_subscribe(mes[0], "low");
		fac_subscribe(mes[0], "high");
	}
	watch_specify(V_NULL, "fac_offtrap", mach, "off");
	watch_specify(V_NULL, "fac_ontrap", mach, "on");
	watch_specify(mes[0], "put", "control", "status");
	return mes_ok();
}

fac_init(){
	int i, N;

	mag_init("factory");
	mes_subscribe("fac_map", fac_map);
	mes_subscribe("fac_switch", fac_switch);
	mes_subscribe("fac_offtrap", fac_offtrap);
	mes_subscribe("fac_ontrap", fac_ontrap);
	mes_subscribe("fac_copy", fac_copy);
	mes_subscribe("fac_register", fac_machinit);
#ifdef PROCESS_SERVER
	db_numretrieve("machine", "N", &N);
	for (i = 0; i < N; i++) {
		extern mag_reply();
		struct value *mach, **mes;

		mach = mag_index("machine", i);
		mes = mes_alloc(4);
		mes[1] = val_sstr("exec", 0);
		mes[2] = db_get(val_str(mach), "cmd", 0);
		mes[3] = mach;
		mes_send_request(val_sstr("host", 0), mes, mag_reply);
	}
#endif
}

main(){
	fac_init();
	win_main_loop();
	mag_exit(0);
}
