/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"
#include "value.h"

fac_objects(){
	db_store("batter", "type", "void");
	db_numstore("batter", "width", 500);
	db_numstore("batter", "height", 500);
	db_numstore("batter", "frame", 1);
	db_store("cookie", "type", "void");
	db_numstore("cookie", "width", 500);
	db_numstore("cookie", "height", 250);
	db_numstore("cookie", "frame", 1);
}

fac_cont(name, cont, x, y, interval, chunk, lowater, hiwater)
char *name, *cont;
{
	char buf[64], *wid, *pic_new();
	int N;

	db_numretrieve(name, "N", &N);
	mag_strnum(buf, N);
	db_store(name, buf, cont);
	db_numstore(name, "N", N + 1);
	db_numstore(cont, "value", 0);
	db_numstore(cont, "interval", interval);
	db_numstore(cont, "chunk", chunk);
	db_numstore(cont, "lowater", lowater);
	db_numstore(cont, "hiwater", hiwater);
#ifdef GRAPH
	wid = pic_new("widget", "graph", cont, x, y, 40, 30, 1, 0);
	db_numstore(wid, "interval", 120);
	db_numstore(wid, "min", 0);
	db_numstore(wid, "max", interval);
	MAG_FREE(wid);
#else
	wid = pic_new("widget", "container", cont, x, y, 25, 40, 1, 1);
	sprintf(buf, "#%s interval #", cont);
	db_store(wid, "attr", "value");
	db_store(wid, "interval", buf);
	MAG_FREE(wid);
#endif
}

fac_register(){
	int mag_reply();
	struct value **mes, **mes_alloc();

	mes = mes_alloc(2);
	mes[1] = val_sstr("fac_register", 0);
	mes_send_request(val_sstr("factory", 0), mes, mag_reply);
}
