/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_mgr.h"
#include "table_client.h"

#define STATE_DOMAIN 	0
#define LOC_RELDES	0
#define LOC_ATTDES	1
#define LOC_NODE	2

void end_replay();

/* system table attribute array */
AttDes sysattr[TBL_SYSNATTR] = {
	{{'r','e','l','a','t','i','o','n','s','\0'},
		TYPE_STRING,
		TBL_MAXNAME}
};

int isis_port;
address *gaddr_p;
RelDes *sys_rel;

main()
{
  void service_maintask();
  char *cp, *getenv();

  cp = getenv("ISISPORT");
  isis_port = cp ? atoi(cp) : 0;

  if (isis_init(isis_port) < 0) isis_perror("table");
  isis_task(service_maintask, "service_maintask");
  isis_entry(WORK_ENTRY, table_process, "work_entry");

  if (isis_mainloop(service_maintask) < 0) isis_perror("table");
}

void service_maintask()
{
  int v, version;
  char logname[30];
  void send_state(), receive_state(), elect();

  /* create table of relation names */
  sys_rel = rel_lookup(TBL_SYSREL, TRUE);
  if (!sys_rel) exit(1);

  v = T_create(sys_rel,
		TRUE, TBL_SYSREPL, TBL_SYSNATTR, sysattr, TRUE, &version);
  if (v != TBL_SUCCESS) exit(1);

  sprintf(logname, "%s%d", TBL_PGNAME, isis_port);
  /* join table server group */
  gaddr_p = pg_join(TBL_PGNAME,
			PG_XFER, STATE_DOMAIN, send_state, receive_state,
		    	PG_LOGGED, logname, WORK_ENTRY,
		    		L_AUTO, end_replay,
		    	PG_MONITOR, elect, 0,
		0);

  if (!gaddr_p) {
    	isis_perror("table");
	exit(1);
  }

  if (isis_start_done() < 0) isis_perror("table");
}

void send_state(locator, gaddr_p)
int locator;
address gaddr_p;
{
  void rel_send();
  xfer_out(-1, "");
  twalk(root_rel, rel_send);
}

void rel_send(rpp, order)
RelDes **rpp;
VISIT order;
{
  AttDes *ap;
  int j, tuple_xfer();
  RelDes *rp;

  rp = *rpp;
  if (POST(order) && rp != sys_rel)
  {
	xfer_out(LOC_RELDES, "%s %d %d %d %d %d",
		rp->name, rp->stable, rp->repl_factor, rp->num_attributes,
		rp->num_tuples, rp->version);

	for (j = 0; j < rp->num_attributes; j++)
	{
		ap = &rp->attributes[j];
		xfer_out(LOC_ATTDES, "%s %d %d",
			ap->AttName, ap->type, ap->clientData);
	}
	twalk(INDEXALL(rp), tuple_xfer);
  }
}

tuple_xfer(tuple, order)
message **tuple;
VISIT order;
{
	if (POST(order)) xfer_out(LOC_NODE, "%m", *tuple);
}

/* receiver state */
RelDes *rp;
int stable, repl_factor, num_attr, delete, version;
AttDes *attributes;
int next_col;

void receive_state(locator, mp)
int locator;
message *mp;
{
  struct node *ep;
  AttDes *ap;
  message *tuple;
  RELNAME name;
  int i, j, n;

  switch(locator)
  {
  case -1:
	/* reset state */
	T_reset(TRUE);
	break;

  case LOC_RELDES:

	msg_get(mp, "%s", name);
	rp = rel_lookup(name, TRUE);

	msg_get(mp, "%d %d %d %d %d",
		&stable, &repl_factor, &num_attr, &n, &version);

	attributes = (AttDes *)malloc(num_attr*sizeof(AttDes));
	next_col = 0;
	break;

  case LOC_ATTDES:
	ap = &attributes[next_col];
	next_col += 1;
	msg_get(mp, "%s %d %d", ap->AttName, &ap->type, &ap->clientData);
	if (next_col == num_attr)
		T_create(rp, stable, repl_factor, num_attr, attributes,
			FALSE, version);
	break;

  case LOC_NODE:
	msg_get(mp, "%m %d", &tuple);
	T_insert(rp, tuple, FALSE);
	break;
  }
}

void end_replay()
{
  /* delete non-stable tables */
  T_reset(0);
  log_checkpoint(TBL_PGNAME);
}

/* global flag indicating lowest rank */
int elected;

void elect(gvp, arg)
groupview *gvp;
int arg;
{
  elected = (pg_rank(&gvp->gv_gaddr, &my_address) == 0);
}

