/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/


#include <stdio.h>
#include "isis.h"
#include "table.h"
#include "tutil.h"
#include "types.h"

tut_read_tuple(in, num_attributes, attributes, tuple)
FILE *in;
int num_attributes;	/* schema of tuple */
AttDes *attributes;
message **tuple;	/* message is allocated and read in */
{

  char s[TYPE_MAXSIZE];
  PTR val;
  int column_num, type;

  *tuple = msg_newmsg();

  for (column_num = 0; column_num < num_attributes; column_num++)
  {
	if (fscanf(in, "%s", s) != 1) return FALSE;
        type = attributes[column_num].type;
	ascii_to_type(type,s,NULL, &val);
	type_pack(type,*tuple, column_num, val);
  }
  return TRUE;
}

