/*

Copyright 1990 by K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "table.h"
#include "tutil.h"
#include "types.h"

tut_dump_tuples(relation, enum_column_num, filename, open_type)
RELNAME relation;
int enum_column_num;
char *filename, *open_type;
{
  FILE *out;
  AttDes *attributes;
  message *tuple;
  long state;
  int num_attributes, column_num;
  TableInfo info;

  out = fopen(filename, open_type);
  if (!out) return TUT_OPEN_FAILED;

  t_startenum(relation, enum_column_num, NULL, &info, &attributes, &state);
  t_enumerate(state, &tuple);

  while (tuple) {
	tut_write_tuple(out, info.num_attr, attributes, tuple);
  	t_enumerate(state, &tuple);
  };

  t_endenum(state);

  fclose(out);
  return TBL_SUCCESS;
}

