/*

Copyright 1990 by M. Beck and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include "isis.h"
#include "types.h"
#include "table.h"
#include "table_client.h"
#include <sys/time.h>

address *t_addrp = 0;

t_tableinit(isis_port)
long isis_port;
{
  struct timeval tv;

  if (t_addrp) return TBL_SUCCESS;

  /* seed random # generator with time of day in usecs */
  gettimeofday(&tv, 0);
  srandom(tv.tv_sec + tv.tv_usec);

  if (isis_init(isis_port) < 0) isis_perror("tableinit");
  t_addrp = pg_lookup(TBL_PGNAME);
  if (!t_addrp || addr_isnull(t_addrp))
  {
    	if (isis_errno) isis_perror("tableinit");
    	return TBL_FAILURE;
  }
  else
	return TBL_SUCCESS;
}
