/*

Copyright 1990 by M. Wood and K. Marzullo
Rights to use this source in unmodified form granted for all
commercial and research uses.  Rights to develop derivative
versions reserved by the authors.

*/

#include <stdio.h>
#include <search.h>
#include <strings.h>

#include "sm.h"

#define CURRENT 1
#define ALERT 2
#define CAN_ALERT 3


SENSOR *sm_getsdf();
extern char *optarg;
extern int optind;
extern int sm_actuate();
extern SENSOR * sm_sensorlookup();
extern int sm_numsensors;         /* number of elements in sensors */


       

main(argc,argv)
int argc;
char *argv[];

{
    static char *sdf = "sdf";
    static char *Useage = "Useage:  do\t [-H] [-I port] [-b]\
\t\t actuator [instance] value\n";
    char * Help = "\n\Options:\n\
\t-H  Prints this message.\n\
\t-I  Use specified ISIS port\n\
\t-b  block until reply\n";


    SENSOR *sensors;            /* pointer to array of sensors */
    SENSOR *cp;			/* pointer to actuator of query */
    char *actuator;			/* actuator */
    char *instance;		        /* instance */
    char * firstperiod;
    int c,numargs;
    int status;
    int block = 0;
    message *m_value;
    PTR value;
    int  isisport;
    char *ipn;
    extern char * getenv();
    
    ipn = getenv("ISISPORT");
    if (ipn) isisport = atoi(ipn);
    while ((c = getopt(argc,argv,"I:Hb")) != EOF) {
	if (c == 'b') {
	    block = TRUE;
        } else if (c == 'I') {
            isisport = atoi(optarg);
	} else if ((c == 'H') || (c  == 'h')) {
	    printf(Useage);
	    printf(Help);
	    exit(0);
	} else {
	    fprintf(stderr,Useage);
	    exit(-1);
	}
    }

    numargs = argc  - optind;
    if (numargs) {
	actuator = argv[optind++];
    } else {
	fprintf(stderr,Useage);
	exit(-1);
    }


    sm_init1(isisport);

    cp = sm_sensorlookup(actuator);

    if (!cp) {
	fprintf(stderr,"Unknown actuator %s\n",actuator);
	exit(-1);
    }

    if (numargs == 2) {
	/* just actuator and value specified */
	instance = "*";
	ascii_to_type(cp->type,argv[optind],NULL,&value);
    } else if (numargs == 3) {
	/* actuator and instance specified */
	instance = argv[optind++];
	ascii_to_type(cp->type,argv[optind],NULL,&value);
    } else {
	fprintf(stderr,Useage);
	exit(-1);
    }

    m_value = msg_newmsg();
    type_pack(cp->type,m_value,SM_VALFLD,value);
#ifdef DEBUG
    printf("Calling actuator manager for (%s,%s)\n",actuator,instance);
    printf("setting value to ");
    type_fprint(stdout,cp->type,value);
    printf("\n");
#endif
    status = sm_actuate(actuator,instance,m_value,block);
    flush();			/* make sure message goes out
				 for nonblocking case! */
#ifdef DEBUG
    printf("done (status = %d)!\n",status);
#endif
    exit(status);
}
