/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This module is a process manager for a UNIX system.  It keeps process
 * related information in a table called "proctab".  proctab#N maintains
 * the maximum number of processes.  proctab#<i> points to a process
 * descriptor record.
 */

#include <stdio.h>
#include <nlist.h>

#ifdef sun
#include <sys/param.h>	/* FSCALE */
#endif

#include "magic.h"
#include "value.h"

struct value **mes_ok(), **mes_error(), *mag_index();

int sys;

struct nlist sys_nlist[] = {
	{"_avenrun"},
	{""},
};

p_getload(){
	if (sys < 0) {
		FILE *popen(), *fp;
		char buf[128], *p = buf, *q = 0;
		double load;

		fp = popen("uptime", "r");
		fgets(buf, sizeof(buf), fp);
		pclose(fp);
		while (*p != 0)
			if (*p++ == ':')
				q = p;
		sscanf(q, "%lf", &load);
		db_dblstore("machine", "load", load);
		return;
	}
	lseek(sys, (long) sys_nlist[0].n_value, 0);
#ifdef sun
	{
		long load;

		read(sys, (char *) &load, sizeof(load));
		db_dblstore("machine", "load", (double) load / FSCALE);
	}
#else
	{
		double load;

		read(sys, (char *) &load, sizeof(load));
		db_dblstore("machine", "load", load / 10));
	}
#endif
}

p_message(pid)
long pid;
{
	struct value *descr;
	int load;

	descr = mag_index("proctab", (int) pid);
	db_store(val_str(descr), "cmd", (char *) 0);
	db_numretrieve("proctab", "load", &load);
	db_numstore("proctab", "load", load - 1);
	val_free(descr);
}

struct value **p_exec(req)
struct value **req;
{
	char buf[128], *cmd;
	struct value *descr;
	int i, n, pid, N, load;

	db_numretrieve("proctab", "load", &load);
	db_numretrieve("proctab", "N", &N);
	if (N == load)
		return mes_error("out of process slots");
	for (pid = 0; pid < N; pid++) {
		descr = mag_index("proctab", pid);
		db_retrieve(val_str(descr), "cmd", &cmd);
		if (cmd == 0)
			break;
		val_free(descr);
		MAG_FREE(cmd);
	}
	n = mes_count(req);
	strcpy(buf, val_str(req[2]));
	for (i = 3; i < n; i++) {
		strcat(buf, " ");
		strcat(buf, val_str(req[i]));
	}
	db_store(val_str(descr), "cmd", buf);
	win_receive(p_message);
	if (fork() == 0) {
		system(buf);
		win_message((long) pid);
		_exit(0);
	}
	val_free(descr);
	db_numstore("proctab", "load", load + 1);
	return mes_ok();
}

struct value **p_update(req)
struct value **req;
{
	db_put("clock", "value", req[4]);
	p_getload();
	return mes_ok();
}

p_init(name)
char *name;
{
	int i, N;
	struct value *descr;

	mag_init(name);
	mes_subscribe("update", p_update);
	mes_subscribe("exec", p_exec);
	db_numstore("proctab", "load", 0);
	db_numretrieve("proctab", "N", &N);
	for (i = 0; i < N; i++) {
		descr = mag_index("proctab", i);
		db_store(val_str(descr), "cmd", (char *) 0);
		val_free(descr);
	}
	if (nlist("/vmunix", sys_nlist) != 0)
		sys = -1;
	else
		sys = open("/dev/kmem", 0);
}

main(argc, argv)
char **argv;
{
	p_init(argv[1]);
	win_main_loop();
	mag_exit(0);
}
