#include "isis.h"
#include "pr_stats.h"
#include "magic.h"
#include "value.h"

struct value **mes_ok(), **mes_alloc();

stat_copy(is)
struct isis_stats *is;
{
	db_numstore("isis", "time",	is->is_time);
	db_numstore("isis", "ntasks",	is->is_ntasks);
	db_numstore("isis", "nlocdel",	is->is_nlocdelete);
	db_numstore("isis", "ndelete",	is->is_ndelete);
	db_numstore("isis", "cgstmask",	is->is_congest);
	db_numstore("isis", "memuse",	is->is_memuse);
	db_numstore("isis", "msgmem",	is->is_msgmem);
	db_numstore("isis", "inter",	is->is_inter);
	db_numstore("isis", "nfork",	is->is_stats[S_NFORK]);
	db_numstore("isis", "nswtch",	is->is_stats[S_NSWTCH]);
	db_numstore("isis", "cbstart",	is->is_stats[S_CBSTART]);
	db_numstore("isis", "cbdone",	is->is_stats[S_CBDONE]);
	db_numstore("isis", "abstart",	is->is_stats[S_ABSTART]);
	db_numstore("isis", "abdone",	is->is_stats[S_ABDONE]);
	db_numstore("isis", "gbstart",	is->is_stats[S_GBSTART]);
	db_numstore("isis", "gbdone",	is->is_stats[S_GBDONE]);
	db_numstore("isis", "gbaborts",	is->is_stats[S_GBABORTS]);
	db_numstore("isis", "fanout",	is->is_stats[S_FANOUT]);
	db_numstore("isis", "cbsent",	is->is_stats[S_CBSENT]);
	db_numstore("isis", "cbcount",	is->is_stats[S_CBCOUNT]);
	db_numstore("isis", "cbdeliv",	is->is_stats[S_CBDELIV]);
	db_numstore("isis", "cbdup",	is->is_stats[S_CBDUP]);
	db_numstore("isis", "asrounds",	is->is_stats[S_ASROUNDS]);
	db_numstore("isis", "syscalls",	is->is_stats[S_SYSCALLS]);
	db_numstore("isis", "clsent",	is->is_stats[S_CLSENT]);
	db_numstore("isis", "cfault",	is->is_stats[S_CFAULT]);
	db_numstore("isis", "lookup",	is->is_stats[S_LOOKUP]);
	db_numstore("isis", "vchange",	is->is_stats[S_VCHANGE]);
	db_numstore("isis", "isent",	is->is_stats[S_ISENT]);
	db_numstore("isis", "igot",	is->is_stats[S_IGOT]);
	db_numstore("isis", "imsgs",	is->is_stats[S_IMSGS]);
	db_numstore("isis", "congest",	is->is_stats[S_CONGEST]);
}

stat_get(is)
struct isis_stats *is;
{
	message *mp = msg_newmsg();

	isis(PR_STATS, mp, is, sizeof(*is));
	msg_delete(mp);
}

struct value **stat_tick(req)
struct value **req;
{
	struct isis_stats isis_stats;

	stat_get(&isis_stats);
	stat_copy(&isis_stats);
	return mes_ok();
}

struct value **stat_flag(req)
struct value **req;
{
	db_numstore("flag", val_str(req[3]), 1);
	return mes_ok();
}

stat_clock(){
	struct value **mes = mes_alloc(5);
	int mag_reply();

	mes[1] = val_sstr("watch", 0);
	mes[2] = val_sstr("put", 0);
	mes[3] = val_sstr("clock", 0);
	mes[4] = val_sstr("value", 0);
	mes_send_request(val_sstr("clock", 0), mes, mag_reply);
}

main(){
	char *getenv(), *port = getenv("ISISPORT");

	isis_init(port == 0 ? 1603 : atoi(port));
	mag_init("isisstat");
	sel_init();
	stat_clock();
	db_store("isis", "timer", "# clock value # 10 $div 10 *");
	db_store("diff", "$default", "# isis $attr std.func diff # $eval");
	db_store("g", "a", "diff $record attr # 100 std.func min # $eval");
	db_store("g", "b", "diff $record attr # 100 std.func max # $eval");
	db_numstore("diff", "N", 0);
	mes_subscribe("stat_tick", stat_tick);
	mes_subscribe("stat_flag", stat_flag);
	watch_specify(V_NULL, "stat_flag", "isis", "cfault");
	watch_specify(V_NULL, "stat_flag", "isis", "vchange");
	sel_loop();
	mag_exit(0);
}
