/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * Much too complicated.  I don't feel like documenting it anymore.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include <ctype.h>
#include "win.h"

extern Display *x_dpy;
extern XFontStruct *x_fs;

struct column {
	struct value *c_valattr, *c_valfmt, *c_valmode;
	char *c_attr;		/* name of attribute */
	int c_width;		/* width of the column */
	int c_offset;		/* offset in column */
	char *c_format;		/* left, center, or right */
	char *c_mode;		/* ro (read-only) */
};

char *tbl_select;	/* name of widget holding selection */
int tbl_row, tbl_col;	/* describes the entry in the matrix */
int tbl_begin, tbl_end;	/* describes the position of the selection */
int tbl_count;		/* click count */
int tbl_dragcol, tbl_dragx;

char *mag_new();
struct value *mag_index(), *db_get();

tbl_column(name, attr, width, offset, format, mode)
char *name, *attr, *format, *mode;
{
	char *column;

	column = mag_new(name);
	db_store(column, "attr", attr);
	db_numstore(column, "width", width);
	db_numstore(column, "offset", offset);
	db_store(column, "format", format);
	db_store(column, "mode", mode);
	MAG_FREE(column);
}

tbl_start(val)
char *val;
{
	char *p;

	switch (tbl_count) {
	case 1:
		return m_min(tbl_begin, tbl_end);
	case 2:
		p = &val[m_min(tbl_begin, tbl_end)];
		while (p > val)
			if (p[-1] == ' ')
				break;
			else
				p--;
		return p - val;
	}
	return 0;
}

tbl_finish(val)
char *val;
{
	int len = strlen(val);
	char *p;

	switch (tbl_count) {
	case 1:
		return m_min(m_max(tbl_begin, tbl_end), len);
	case 2:
		p = &val[m_min(m_max(tbl_begin, tbl_end), len)];
		while (*p != 0)
			if (*++p == ' ')
				break;
		return p - val;
	}
	return len;
}

tbl_freecols(c, ncol)
struct column *c;
{
	int col;

	for (col = 0; col < ncol; col++) {
		val_free(c[col].c_valattr);
		val_free(c[col].c_valfmt);
		val_free(c[col].c_valmode);
	}
	MAG_FREE(c);
}

struct column *tbl_getcols(name, ncol, width)
char *name;
int *ncol, *width;
{
	extern db_seq;
	struct value *v_col;
	char *column;
	struct column *carr, *c;
	int col;

	db_numretrieve(name, "N", ncol);
	if (*ncol <= 0)
		return 0;
	carr = MAG_ALLOC(*ncol, struct column);
	*width = 0;
	for (c = carr, col = 0; col < *ncol; c++, col++) {
		v_col = mag_index(name, col);
		if ((column = val_str(v_col)) != 0) {
			c->c_valattr = db_get(column, "attr", db_seq);
			c->c_valfmt = db_get(column, "format", db_seq);
			c->c_valmode = db_get(column, "mode", db_seq);
			c->c_attr = val_str(c->c_valattr);
			c->c_format = val_str(c->c_valfmt);
			c->c_mode = val_str(c->c_valmode);
			db_numretrieve(column, "width", &c->c_width);
			db_numretrieve(column, "offset", &c->c_offset);
			*width += c->c_width;
		}
		val_free(v_col);
	}
	if (*width <= 0) {
		tbl_freecols(carr, *ncol);
		return 0;
	}
	return carr;
}

/* Calculate the offset in the column.  This depends on the mode and the
 * difference between the width of the column and the width of the contents.
 */
tbl_offset(c, delta)
struct column *c;
{
	if (c->c_format == 0 || *c->c_format == 'c')
		return delta / 2 + c->c_offset;
	if (*c->c_format == 'r')
		return delta + c->c_offset;
	return c->c_offset;
}

char *tbl_value(row, col, transpose)
char *row, *col;
{
	char *rec, *attr, *val;

	if (row == 0 || col == 0)
		return 0;
	if (transpose) {
		rec = col;
		attr = row;
	}
	else {
		rec = row;
		attr = col;
	}
	if (scmp(attr, "name"))
		return mag_copy(rec);
	db_retrieve(rec, attr, &val);
	return val;
}

tbl_startdrag(o, x)
struct object *o;
{
	int ncol, total, xpos, col, width;
	struct column *c;

	if ((c = tbl_getcols(o->o_name, &ncol, &width)) == 0)
		return;
	for (xpos = total = 0, col = 0; col < ncol; col++) {
		total += c[col].c_width;
		xpos = total * o->o_width / width;
		if (x < xpos)
			break;
	}

	tbl_dragcol = col;
	tbl_dragx = x - c[col].c_offset;

	tbl_freecols(c, ncol);
}

tbl_drag(o, x)
struct object *o;
{
	struct value *v_col;
	char *column;

	v_col = mag_index(o->o_name, tbl_dragcol);
	if ((column = val_str(v_col)) != 0)
		db_numstore(column, "offset", x - tbl_dragx);
	val_free(v_col);
}

tbl_press(o, x, y, key, count)
struct object *o;
{
	struct value *v_ent;
	char *ent, *val;
	int ncol, nrow, total, direct, transpose, start, number;
	int xpos, col, row, offset, width;
	struct column *c;

	if (key != 0) {
		tbl_startdrag(o, x);
		return;
	}
	if (o->o_record == 0)
		return;
	db_numretrieve(o->o_name, "transpose", &transpose);
	db_numretrieve(o->o_record, "direct", &direct);
	if (direct) {
		row = start = 0;
		nrow = number = 1;
	}
	else {
		db_numretrieve(o->o_record, "N", &nrow);
		db_numretrieve(o->o_name, "start", &start);
		db_numretrieve(o->o_name, "number", &number);
		if (number == 0)
			number = nrow;
		if (start > nrow - number)
			start = nrow - number;
		if (start < 0)
			start = 0;
		row = y * number / o->o_height;
	}

	/* Locate which attribute is being pointed at.
	 */
	if ((c = tbl_getcols(o->o_name, &ncol, &width)) == 0)
		return;
	for (xpos = total = 0, col = 0; col < ncol; col++) {
		total += c[col].c_width;
		offset = xpos;
		xpos = total * o->o_width / width;
		if (x < xpos)
			break;
	}

	tbl_select = mag_copy(o->o_name);
	tbl_count = count % 3;
	tbl_row = start + row;
	tbl_col = col;

	/* Retrieve the value that's in there.
	 */
	if (col != ncol) {
		if (direct)
			ent = o->o_record;
		else {
			v_ent = mag_index(o->o_record, tbl_row);
			ent = val_str(v_ent);
		}
		if ((val = tbl_value(ent, c[col].c_attr, transpose)) != 0) {
			/* Calculate the offset of the value and find
			 * the position within the value.
			 */
			x -= offset + tbl_offset(&c[col], xpos - offset -
					XTextWidth(x_fs, val, strlen(val)));
			for (xpos = 0; xpos < strlen(val); xpos++)
				if (x < XTextWidth(x_fs, val, xpos + 1))
					break;
			tbl_begin = tbl_end = xpos;
			MAG_FREE(val);
		}
		if (!direct)
			val_free(v_ent);
	}
	tbl_freecols(c, ncol);
}

tbl_track(o, x, y, key)
struct object *o;
{
	struct value *v_ent;
	char *ent, *val;
	int ncol, total, direct, transpose, xpos, col, offset, width;
	struct column *c;

	if (key != 0) {
		tbl_drag(o, x);
		return;
	}
	if (tbl_select == 0 || o->o_record == 0)
		return;

	/* Locate which attribute is being pointed at.
	 */
	if ((c = tbl_getcols(o->o_name, &ncol, &width)) == 0)
		return;
	for (xpos = total = 0, col = 0;; col++) {
		total += c[col].c_width;
		offset = xpos;
		xpos = total * o->o_width / width;
		if (col == tbl_col)
			break;
	}

	db_numretrieve(o->o_name, "transpose", &transpose);
	db_numretrieve(o->o_name, "direct", &direct);

	/* Retrieve the value that's in there.
	 */
	if (col != ncol) {
		if (direct)
			ent = o->o_record;
		else {
			v_ent = mag_index(o->o_record, tbl_row);
			ent = val_str(v_ent);
		}
		if ((val = tbl_value(ent, c[col].c_attr, transpose)) != 0) {
			x -= offset + tbl_offset(&c[col], xpos - offset -
					XTextWidth(x_fs, val, strlen(val)));
			for (xpos = 0; xpos < strlen(val); xpos++)
				if (x < XTextWidth(x_fs, val, xpos + 1))
					break;
			tbl_end = xpos;
			MAG_FREE(val);
		}
		if (!direct)
			val_free(v_ent);
	}
	tbl_freecols(c, ncol);
}

/* Return a string copy of the given number.
 */
char *tbl_number(n){
	char buf[16];

	mag_strnum(buf, n);
	return mag_copy(buf);
}

/* Edit the current selection.  c is the input character.  The selection
 * is replaced by the input.
 */
tbl_input(o, c)
struct object *o;
char c;
{
	struct value *v_col, *v_ent;
	char buf[256], *column, *mode, *ent, *attr, *val, *p;
	int direct, transpose, ncol, nrow, ro, skip = 0;

	if (!isascii(c) || tbl_select == 0 || o->o_record == 0) {
		mag_bleep();
		return;
	}

	db_numretrieve(o->o_name, "N", &ncol);
	v_col = mag_index(o->o_name, tbl_col);
	column = val_str(v_col);
	db_retrieve(column, "mode", &mode);
	ro = mode != 0 && scmp(mode, "ro");
	MAG_FREE(mode);
	db_retrieve(column, "attr", &attr);
	db_numretrieve(o->o_name, "transpose", &transpose);
	db_numretrieve(o->o_name, "direct", &direct);
	if (direct) {
		nrow = 1;
		ent = o->o_record;
	}
	else {
		db_numretrieve(o->o_record, "N", &nrow);
		v_ent = mag_index(o->o_record, tbl_row);
		ent = val_str(v_ent);
	}
	if ((val = tbl_value(ent, attr, transpose)) == 0) {
		p = buf;
		*p = 0;
	}
	else {
		strncpy(buf, val, tbl_start(val));
		p = &buf[tbl_start(val)];
	}
	if (isprint(c))
		*p++ = c;
	else
		switch (c & 0x7F) {
		case 0x7F:
			break;
		case 'H' & 0x1F:
			if (val != 0 && p > buf)
				--p;
			break;
		case 'U' & 0x1F:
			if (val != 0) {
				p = buf;
				MAG_FREE(val);
				val = 0;
			}
			break;
		case 'W' & 0x1F:
			if (val != 0) {
				while (p > buf)
					if (*--p != ' ')
						break;
				while (p > buf)
					if (*--p == ' ') {
						p++;
						break;
					}
			}
			break;
		case 'M' & 0x1F:
			tbl_col = 0;
			if (++tbl_row == nrow)
				tbl_row = 0;
			skip = 1;
			break;
		case 'J' & 0x1F:
		case 'N' & 0x1F:
			if (++tbl_row == nrow) {
				tbl_row = 0;
				if (++tbl_col == ncol)
					tbl_col = 0;
			}
			skip = 1;
			break;
		case 'F' & 0x1F:
		case 'I' & 0x1F:
		case 'L' & 0x1F:
			if (++tbl_col == ncol) {
				tbl_col = 0;
				if (++tbl_row == nrow)
					tbl_row = 0;
			}
			skip = 1;
			break;
		case 'K' & 0x1F:
		case 'P' & 0x1F:
			if (tbl_row == 0) {
				tbl_row = nrow;
				if (tbl_col == 0)
					tbl_col = ncol;
				tbl_col--;
			}
			tbl_row--;
			skip = 1;
			break;
		case 'B' & 0x1F:
			if (tbl_col == 0) {
				tbl_col = ncol;
				if (tbl_row == 0)
					tbl_row = nrow;
				tbl_row--;
			}
			tbl_col--;
		case 'G' & 0x1F:
			skip = 1;
			break;
		default:
			mag_bleep();
		}
	if (skip)
		tbl_count = 0;
	else {
		if (val == 0 && p > buf) {
			val = MAG_ALLOC(1, char);
			tbl_begin = tbl_end = 0;
		}

		if (scmp(attr, "name")) {
			if (!direct) {
				val_free(v_ent);
				direct = 1;
			}
			MAG_FREE(attr);
			ent = o->o_record;
			attr = tbl_number(tbl_row);
		}

		if (ent != 0)
			if (ro)
				mag_bleep();
			else if (val == 0)
				if (transpose)
					db_store(attr, ent, (char *) 0);
				else
					db_store(ent, attr, (char *) 0);
			else {
				strcpy(p, &val[tbl_finish(val)]);
				if (transpose)
					db_store(attr, ent, buf);
				else
					db_store(ent, attr, buf);
				tbl_begin = tbl_end = p - buf;
				tbl_count = 1;
			}
	}

	if (!direct)
		val_free(v_ent);
	val_free(v_col);
	MAG_FREE(val);
	MAG_FREE(attr);
}

tbl_getsel(o, xs)
struct object *o;
XSelectionRequestEvent *xs;
{
	struct value *v_col, *v_ent;
	char *ent, *attr, *val;
	int direct, transpose;

	if (tbl_select == 0)
		return;

	v_col = mag_index(o->o_name, tbl_col);
	db_retrieve(val_str(v_col), "attr", &attr);
	val_free(v_col);
	db_numretrieve(o->o_name, "transpose", &transpose);
	db_numretrieve(o->o_name, "direct", &direct);
	if (direct)
		ent = o->o_record;
	else {
		v_ent = mag_index(o->o_record, tbl_row);
		ent = val_str(v_ent);
	}
	if ((val = tbl_value(ent, attr, transpose)) == 0)
		xs->property = None;
	else {
		XChangeProperty(x_dpy, xs->requestor, xs->property,
			xs->target, 8, PropModeReplace, &val[tbl_start(val)],
			tbl_finish(val) - tbl_start(val));
		MAG_FREE(val);
	}

	if (!direct)
		val_free(v_ent);
	MAG_FREE(attr);
}

tbl_endsel(o)
struct object *o;
{
	MAG_FREE(tbl_select);
	tbl_select = 0;
}

tbl_draw(w, o)
struct window *w;
struct object *o;
{
	XCharStruct xcs;
	struct value *v_ent;
	char *ent, *val;
	int ncol, nrow, rowht, direct, transpose, total, start, number;
	int xpos, ypos, col, row, dir, fam, fdm, offset, x1, y1, x2, y2;
	int colwid, width;
	struct column *c;

	if (o->o_record == 0)
		return;
	if ((c = tbl_getcols(o->o_name, &ncol, &width)) == 0)
		return;
	for (xpos = o->o_x, col = total = 0; col < ncol - 1; col++) {
		total += c[col].c_width;
		xpos = o->o_x + total * o->o_width / width;
		win_line(w, xpos, o->o_y, xpos, o->o_y + o->o_height);
	}

	db_numretrieve(o->o_name, "transpose", &transpose);
	db_numretrieve(o->o_name, "direct", &direct);
	if (direct) {
		start = 0;
		nrow = number = 1;
		rowht = o->o_height;
	}
	else {
		db_numretrieve(o->o_name, "start", &start);
		db_numretrieve(o->o_name, "number", &number);
		db_numretrieve(o->o_record, "N", &nrow);
		if (number == 0)
			number = nrow;
		if (start > nrow - number)
			start = nrow - number;
		if (start < 0)
			start = 0;
		if (number != 0)
			rowht = o->o_height / number;
	}
	for (row = 0; row < number; row++) {
		ypos = o->o_y + (row + 1) * o->o_height / number;
		if (row < number - 1)
			win_line(w, o->o_x, ypos, o->o_x + o->o_width, ypos);
		if (rowht < 10 || start + row >= nrow)
			continue;
		if (direct)
			ent = o->o_record;
		else {
			v_ent = mag_index(o->o_record, start + row);
			ent = val_str(v_ent);
		}
		xpos = o->o_x;
		for (col = total = 0; col < ncol; xpos += colwid, col++) {
			total += c[col].c_width;
			colwid = o->o_x + total * o->o_width / width - xpos;
			val = tbl_value(ent, c[col].c_attr, transpose);
			if (val != 0)
				win_string(w, xpos + c[col].c_offset, ypos,
					colwid, rowht, val, c[col].c_format);
				
			/* If this is the entry containing the selection,
			 * highlight the selection.
			 */
			if (tbl_select != 0 && scmp(o->o_name, tbl_select) &&
			    row == tbl_row - start && col == tbl_col) {
				if (val == 0) {
					x1 = xpos;
					y1 = ypos - rowht;
					x2 = xpos + colwid;
					y2 = ypos;
				}
				else {
					XTextExtents(x_fs, val, strlen(val),
						&dir, &fam, &fdm, &xcs);
					offset = tbl_offset(&c[col],
						colwid - xcs.width);
					x1 = x2 = offset + xpos;
					y1 = y2 = ypos;
					x1 += XTextWidth(x_fs, val,
							tbl_start(val)) - 1;
					x2 += XTextWidth(x_fs, val,
							tbl_finish(val));
					y1 -= (rowht + xcs.descent +
							xcs.ascent) / 2 + 1;
					y2 -= (rowht - xcs.descent -
							xcs.ascent) / 2 - 1;
					while (y2 - y1 < rowht / 2) {
						y1--;
						y2++;
					}
				}
				win_fillrect(w, x1, y1, x2 - x1, y2 - y1);
			}
			MAG_FREE(val);
		}
		if (!direct)
			val_free(v_ent);
	}
	tbl_freecols(c, ncol);
}

/* This shows information about table widgets.
 */
tbl_edit(){
	char *wid, *pic_new();

	db_store("edit.buffer", "table", "edit.buffer.table");

	mag_append("edit.buffer.tbl.row",
				"#edit.buffer selection # record #", 0);
	wid = pic_new("edit.buffer.table", "table", "edit.buffer.tbl.row",
			0, 0, 180, 25, 1, 1);
	tbl_column(wid, "N", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new("edit.buffer.table", "table",
		"#edit.buffer selection # record #", 0, 30, 180, 540, 1, 1);
	db_store(wid, "height", "# $record record # N # $dup 1 ? 20 *");
	tbl_column(wid, "name", 1, 0, "c", (char *) 0); 
	MAG_FREE(wid);

	mag_append("edit.buffer.tbl.col", "#edit.buffer selection #", 0);
	wid = pic_new("edit.buffer.table", "table", "edit.buffer.tbl.col",
			190, 0, 390, 25, 1, 1);
	tbl_column(wid, "N", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
	wid = pic_new("edit.buffer.table", "table",
		"#edit.buffer selection #", 190, 30, 390, 540, 1, 1);
	db_store(wid, "height", "# $record record # N # $dup 1 ? 20 *");
	tbl_column(wid, "name", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "attr", 2, 0, "c", (char *) 0); 
	tbl_column(wid, "width", 1, 0, "c", (char *) 0); 
	tbl_column(wid, "offset", 1, 0, "c", (char *) 0); 
	tbl_column(wid, "format", 1, 0, "c", (char *) 0); 
	MAG_FREE(wid);
}
