/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * A message is a null-terminated vector of values.  The first value is
 * the name of the source station and its sequence number.  The second
 * string is the type of the message.  The following strings are arguments.
 *
 * A conversation is initiated by the requestor.  It generates a new
 * conversation identifier that is local to the requestor's station.
 * The reply to the request contains the same conversation identifier so
 * that the requestor may match the reply to the request (the reply is
 * received asynchronously).
 */

#include "value.h"
#include "expr.h"
#include "magic.h"

extern db_seq;
extern char *mag_me;

/* In this table we maintain the names of requests, the function to
 * call, and the argument to give to the function.
 */
struct dispatch {
	char *d_cmd;			/* name of the request */
	struct value **(*d_request)();	/* request function */
	struct dispatch *d_next;
} *mes_dispatch;

/* Print a message.
 */
mes_print(mess)
struct value **mess;
{
	printf("%s <%d>:\n", val_str(*mess), val_seq(*mess));
	while (*++mess != 0)
		printf("\t%s <%d>\n", val_str(*mess), val_seq(*mess));
}

/* Allocate a message and put the name and sequence number of this station
 * in it.
 */
struct value **mes_alloc(n){
	struct value **mess;

	mess = MAG_ALLOC(n + 1, struct value *);
	mess[0] = val_sstr(mag_me, db_seq);
	return mess;
}

/* Free all strings in the message, and the message itself.
 */
mes_free(mess)
struct value **mess;
{
	struct value **v = mess;

	while (*v != 0) {
		val_free(*v);
		v++;
	}
	MAG_FREE(mess);
}

/* Count the number of strings in this message.
 */
mes_count(mess)
struct value **mess;
{
	int count = 0;

	while (*mess++ != 0)
		count++;
	return count;
}

/* Make up an ok reply message.
 */
struct value **mes_ok(){
	struct value **rep;

	rep = mes_alloc(2);
	rep[1] = val_sstr("ok", db_seq);
	return rep;
}

/* Make up an error reply message containing s.
 */
struct value **mes_error(s)
char *s;
{
	struct value **rep;

	rep = mes_alloc(3);
	rep[1] = val_sstr("error", db_seq);
	rep[2] = val_cstr(s, db_seq);
	return rep;
}

/* Each time a request message arrives with a cmd field, call the function
 * request with first argument ident and second argument the request itself.
 */
mes_subscribe(cmd, request)
char *cmd;
struct value **(*request)();
{
	struct dispatch *d;

	d = MAG_ALLOC(1, struct dispatch);
	d->d_cmd = mag_copy(cmd);
	d->d_request = request;
	d->d_next = mes_dispatch;
	mes_dispatch = d;
}

/* Asynchronous RPC.
 */
mes_send_request(dest, request, reply)
struct value *dest, **request;
int (*reply)();
{
	com_send_request(dest == 0 ? val_sstr(mag_me, 0) : dest,
							request, reply);
}

/* A request has been received.  Scan the dispatch table to see if it's a
 * known command.  If so, call the appropriate procedure.  If not, return
 * an error.
 */
struct value **mes_recv_request(req)
struct value **req;
{
	struct dispatch *d;
	char *cmd;

	if (mes_count(req) < 2)
		return mes_error("bad message format");
	cmd = val_str(req[1]);
	for (d = mes_dispatch; d != 0; d = d->d_next)
		if (scmp(d->d_cmd, cmd))
			return (*d->d_request)(req);
	return mes_error("no such command");
}
