/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

char *menu_name;
int menu_select = -1;

menu_track(o, x, y)
struct object *o;
{
	int N, horiz;

	if (o->o_record == 0)
		return;
	db_numretrieve(o->o_name, "horiz", &horiz);
	if (horiz)
		if (x < 0 || x >= o->o_width)
			menu_select = -1;
		else {
			db_numretrieve(o->o_record, "N", &N);
			menu_select = x * N / o->o_width;
		}
	else
		if (y < 0 || y >= o->o_height)
			menu_select = -1;
		else {
			db_numretrieve(o->o_record, "N", &N);
			menu_select = y * N / o->o_height;
		}
}

menu_press(o, x, y, count)
struct object *o;
{
	menu_name = mag_copy(o->o_name);
	menu_track(o, x, y);
}

menu_release(o, x, y)
struct object *o;
{
	if (o->o_record != 0 && menu_select >= 0) {
		db_numstore(o->o_record, "select", menu_select);
		menu_select = -1;
	}
	MAG_FREE(menu_name);
	menu_name = 0;
}

menu_draw(w, o)
struct window *w;
struct object *o;
{
	int N, select, horiz, start, length;

	if (o->o_record == 0)
		return;
	db_numretrieve(o->o_record, "N", &N);
	if (N == 0)
		return;
	if (menu_name != 0 && scmp(menu_name, o->o_name))
		select = menu_select;
	else if (!db_numretrieve(o->o_record, "select", &select))
		return;
	db_numretrieve(o->o_name, "horiz", &horiz);
	if (horiz) {
		start = select * o->o_width / N;
		length = ++select * o->o_width / N - start;
		win_fillrect(w, o->o_x + start, o->o_y, length, o->o_height);
	}
	else {
		start = select * o->o_height / N;
		length = ++select * o->o_height / N - start;
		win_fillrect(w, o->o_x, o->o_y + start, o->o_width, length);
	}
}
