/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This stuff prints graphs.  There are some options.  If the attribute
 * "style" equals "hist", it draws a histogram, otherwise it just connects
 * the points.  If "fill" is black, the stuff under the graph is blackened.
 */

#include "magic.h"
#include "value.h"
#include <X11/Xlib.h>
#include "win.h"

extern db_seq;

struct value *db_get();

/* Draw a piece of the graph.
 */
graph_atom(w, o, style, fill, x1, y1, x2, y2)
struct window *w;
struct object *o;
char *style, *fill;
{
	XPoint p[4];
	int xb = o->o_x, yb = o->o_y + o->o_height;

	if (style != 0 && scmp(style, "hist")) {
		if (x1 < 0)	/* clip */
			x1 = 0;
		if (fill != 0 && scmp(fill, "black"))
			win_fillrect(w, xb + x1, yb - y1, x2 - x1, y1);
		else {
			win_line(w, xb + x1, yb - y1, xb + x2, yb - y1);
			win_line(w, xb + x2, yb - y1, xb + x2, yb - y2);
		}
	}
	else {
		if (x1 < 0) {	/* clip */
			y1 -= (y2 - y1) * x1 / (x2 - x1);
			x1 = 0;
		}
		if (fill != 0 && scmp(fill, "black")) {
			p[0].x = xb + x1;	p[0].y = yb;
			p[1].x = xb + x1;	p[1].y = yb - y1;
			p[2].x = xb + x2;	p[2].y = yb - y2;
			p[3].x = xb + x2;	p[3].y = yb;
			win_fillpoly(w, p, 4);
		}
		else
			win_line(w, xb + x1, yb - y1, xb + x2, yb - y2);
	}
}

/* Draw a graph.
 */
graph_draw(w, o)
struct window *w;
struct object *o;
{
	struct value *v;
	char *attr, *style, *fill;
	int interval, seq, now, t, first = 1, x1, y1, x2, y2;
	double min, max;

	db_numretrieve(o->o_name, "interval", &interval);
	if (interval == 0)
		return;
	db_dblretrieve(o->o_name, "min", &min);
	db_dblretrieve(o->o_name, "max", &max);
	if (min >= max)
		return;
	db_retrieve(o->o_name, "attr", &attr);
	if (attr == 0)
		return;
	db_retrieve(o->o_name, "style", &style);
	db_retrieve(o->o_name, "fill", &fill);
	db_numretrieve("clock", "value", &now);
	seq = db_seq;
	x1 = o->o_width;
	do {
		v = db_get(o->o_record, attr, seq);
		if (val_null(v)) {
			val_free(v);
			break;
		}
		seq = val_seq(v);
		y2 = (val_dbl(v) - min) * o->o_height / (max - min);
		val_free(v);
		v = db_get("clock", "value", seq);
		if (val_null(v))
			t = now - interval;
		else
			t = val_int(v);
		val_free(v);
		x2 = (t - now + interval) * o->o_width / interval;
		if (first) {
			y1 = y2;
			first = 0;
		}
		graph_atom(w, o, style, fill, x2, y2, x1, y1);
		x1 = x2;
		y1 = y2;
		seq--;
	} while (x2 > 0);
	MAG_FREE(attr);
	MAG_FREE(style);
	MAG_FREE(fill);
}

/* This shows information about graph widgets.
 */
graph_edit(){
	char *wid, *pic_new();

	db_store("edit.buffer", "graph", "edit.buffer.graph");

	mag_append("edit.buffer.grp", "edit.buffer.grp.schema", 0);
	mag_append("edit.buffer.grp", "#edit.buffer selection #", 0);
	db_store("edit.buffer.grp.schema", "attr", "attribute");
	db_store("edit.buffer.grp.schema", "interval", "interval");
	db_store("edit.buffer.grp.schema", "min", "minimum");
	db_store("edit.buffer.grp.schema", "max", "maximum");
	db_store("edit.buffer.grp.schema", "style", "style");
	db_store("edit.buffer.grp.schema", "fill", "fill");
	wid = pic_new("edit.buffer.graph", "table", "edit.buffer.grp",
						0, 0, 580, 40, 1, 1);
	tbl_column(wid, "attr", 1, 0, "c", (char *) 0);
	tbl_column(wid, "interval", 1, 0, "c", (char *) 0);
	tbl_column(wid, "min", 1, 0, "c", (char *) 0);
	tbl_column(wid, "max", 1, 0, "c", (char *) 0);
	tbl_column(wid, "style", 1, 0, "c", (char *) 0);
	tbl_column(wid, "fill", 1, 0, "c", (char *) 0);
	MAG_FREE(wid);
}
