/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/* Values are a smart way of representing ASCII strings that are often
 * interpreted as numbers.  Also associated with each values is a sequence
 * number, which is sort of the time at which this value was created.
 */

struct value *val_pstr(), *val_cstr(), *val_sstr();
struct value *val_pdbl(), *val_pint(), *val_pseq();

#define V_STR		0x01	/* String present */
#define V_DBL		0x02	/* Double present */
#define V_INT		0x04	/* Integer present */
#define V_STATIC	0x08	/* String is not malloc'ed, but static */

/* Arguments to val_pseq.
 */
#define V_COPY		0	/* Copy value */
#define V_FREE		1	/* Free original value afterwards */

/* Just handy.
 */
#define V_NULL		((struct value *) 0)

/* Printf formats of doubles and integers.
 */
#define V_FMT_DBL	"%.12lg"
#define V_FMT_INT	"%d"

/* This checks whether v points to the null string.
 */
#define val_null(v)	((v) == 0 || (v)->v_assign == 0)

/* This returns the string.  If the string is not currently present, it
 * is generated using val_getstr().
 */
#define val_str(v)	(val_null(v) ? 0 : ((v)->v_present & V_STR) ? \
				(v)->v_str : (val_getstr(v), (v)->v_str))

/* Similarly as val_str we have val_dbl and val_int.
 */
#define val_dbl(v)	(val_null(v) ? 0 : ((v)->v_present & V_DBL) ? \
				(v)->v_dbl : (val_getdbl(v), (v)->v_dbl))
#define val_int(v)	(val_null(v) ? 0 : ((v)->v_present & V_INT) ? \
				(v)->v_int : (val_getint(v), (v)->v_int))

/* This returns the sequence number of the value.
 */
#define val_seq(v)	((v) == 0 ? 0 : (v)->v_seq)

/* This compares two values.  If the pointers aren't the same, call val_docmp.
 */
#define val_cmp(v, w)	((v) == (w) || val_docmp(v, w))

/* Return v, and increment the reference count at the same time.  Each time
 * you give a way a pointer, do it using val_ref.
 */
#define val_ref(v)	((v) == 0 ? 0 : (v)->v_refcnt++, (v))

/* val_free is called to give away values.  If the reference count becomes
 * 0, call val_dofree to really free the associated memory.  val_stat is
 * just a safe way of defining a macro function.
 */
#define val_free(v)	do { struct value *_t; \
			     if ((_t = (v)) != 0 && --_t->v_refcnt <= 0) \
				val_dofree(_t); } while (0)

/* This is the actual value structure.  v_int, v_dbl, or v_str are available
 * depending on the value of v_present.
 */
struct value {
	char v_assign;			/* assigned as what? */
	char v_present;			/* flags of which are valid */
	short v_refcnt;			/* reference count */
	int v_seq;			/* its sequence number */
	int v_int;			/* int value */
	char *v_str;			/* string value */
	double v_dbl;			/* double value */
};
