/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"

#define OFFSET	80
#define WIDTH	40

char *pic_new();

char *table;

fac_mach(mach, cmd, input, output)
char *mach, *cmd, *input, *output;
{
	char buf[64], *wid;
	int N;

	db_numretrieve("machine", "N", &N);
	mag_strnum(buf, N);
	db_store("machine", buf, mach);
	tbl_column(table, buf, 1, 0, "c", "");
	sprintf(buf, "#machine %d #", N);
	wid = pic_new("widget", "container", buf,
			OFFSET + N * WIDTH, 90, WIDTH, 20, 1, 1);
	db_store(wid, "attr", "on/off");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);
	wid = pic_new("widget", "container", buf,
			OFFSET + N * WIDTH, 110, WIDTH, 20, 1, 1);
	db_store(wid, "attr", "mapped");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);
	db_numstore(mach, "on/off", 0);
	db_numstore(mach, "mapped", 0);
	db_store(mach, "cmd", cmd);
	if (*mach == 'm') {
		db_numstore(mach, "low", 1);
		db_numstore(mach, "high", 0);
		db_store(mach, "input", input);
		db_store(mach, "output", output);
		db_store(mach, "off", "# $record on/off # $record low # $record output # high # || &&");
		db_store(mach, "on", "# $record on/off # ! $record low # ! $record output # $dup low # 1 ? && &&");
	}
	else {
		db_numstore(mach, "off", 0);
		db_numstore(mach, "on", 1);
	}
	db_numstore("machine", "N", N + 1);
}

main(){
	char *wid;

	mag_cold("factory", 300, 200, 1);

	wid = pic_new("widget", "container", "menu", 17, 5, 25, 25, 1, 1);
	db_numstore(wid, "interval", 1);
	db_store(wid, "attr", "mapped");
	MAG_FREE(wid);

	mag_append("nametab", "machine", 0);
	table = pic_new("widget", "table", "nametab",
					OFFSET, 70, 160, 20, 1, 1);

	mag_append("switchtab", "on/off", 0);
	mag_append("switchtab", "mapped", 0);
	wid = pic_new("widget", "table", "switchtab",
					OFFSET - 60, 90, 60, 40, 1, 1);
	tbl_column(wid, "name", 1, 0, "c", "");
	MAG_FREE(wid);

	fac_mach("m1", "machine", (char *) 0, "m2");
	fac_mach("b1", "belt", (char *) 0, (char *) 0);
	fac_mach("m2", "machine", "m1", (char *) 0);
	fac_mach("b2", "belt", (char *) 0, (char *) 0);
	mag_exit(0);
}
