/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

#include "magic.h"

#define SCALE	8192
#define NUMBER	10

char *pic_new();

belt_append(name, type, x1, y1, x2, y2)
char *name, *type;
{
	MAG_FREE(pic_new(name, type, (char *) 0,
					x1, y1, x2 - x1, y2 - y1, 0, 0));
}

belt_init(name, dest, length)
char *name, *dest, *length;
{
	char *wid, buf[64], object[64];
	int i;

	mag_cold(name, 265, 100, 0);
	fac_objects();

	belt_append("cbelt", "line", 250, 0, SCALE - 250, 0);
	belt_append("cbelt", "line", 250, 500, SCALE - 250, 500);
	belt_append("cbelt", "circle", 0, 0, 500, 500);
	belt_append("cbelt", "circle", 
			SCALE / 3 - 250, 0, SCALE / 3 + 250, 500);
	belt_append("cbelt", "circle",
		2 * SCALE / 3 - 250, 0, 2 * SCALE / 3 + 250, 500);
	belt_append("cbelt", "circle", SCALE - 500, 0, SCALE, 500);
	MAG_FREE(pic_new("widget", "picture", "cbelt",
					20, 60, 200, 200, 0, 0));

	MAG_FREE(pic_new("widget", "picture", name, 20, 60, 200, 200, 0, 0));

	db_numstore(name, "N", NUMBER);
	db_store(name, "length", length);
	db_store(name, "dest", dest);
	db_numstore(name, "in", 0);
	db_numstore(name, "out", 0);

	for (i = 0; i < NUMBER; i++) {
		sprintf(object, "%s.%d", name, i);
		db_store(object, "$default", "# $record product # $attr #");
		sprintf(buf, "# clock value # $record time # - %d * %s length # /", SCALE, name);
		db_store(object, "x", buf);
		db_store(object, "y", "# $record height # $neg");
		db_clrcache(object);
	}

	wid = pic_new("widget", "container", name, 30, 10, 150, 20, 1, 1);
	db_store(wid, "attr", "length");
	db_numstore(wid, "interval", 60);
	db_store(wid, "direction", "east");
	MAG_FREE(wid);

	wid = pic_new("widget", "container", "onoff", 235, 5, 25, 25, 1, 1);
	db_store(wid, "attr", "value");
	db_numstore(wid, "interval", 1);
	MAG_FREE(wid);

	watch_cold("clock", "update", "clock", "value");
}

main(argc, argv)
char **argv;
{
	belt_init(argv[1], argv[2], argv[3]);
	mag_exit(0);
}
