/*
 *      Originally coded by Robbert van Renesse
 *
 *
 *      ISIS release V2.0, May 1990
 *      Export restrictions apply
 *
 *      The contents of this file are subject to a joint, non-exclusive
 *      copyright by members of the ISIS Project.  Permission is granted for
 *      use of this material in unmodified form in commercial or research
 *      settings.  Creation of derivative forms of this software may be
 *      subject to restriction; obtain written permission from the ISIS Project
 *      in the event of questions or for special situations.
 *      -- Copyright (c) 1990, The ISIS PROJECT
 */

/*
 * This simulates a conveyor belt.  The belt widget has the following
 * attributes:
 *
 *	N:	the maximum number of items on the belt
 *	length:	the time (in seconds) it takes from beginning to end
 *	dest:	name of destination
 *	in:	the first entry that is free
 *	out:	the last entry that was used
 *	[i]:	the name of the widget on the belt (null means unused)
 */

#include "magic.h"
#include "value.h"

extern db_seq;

struct value **mes_alloc(), **mes_ok(), *mag_index();
struct value *db_get();

char *belt_name;

struct value **belt_update(req)
struct value **req;
{
	char object[64];
	struct value **mes, *dest, *item, *product;
	int value, time, length, N, in, out, t, mag_reply();

	db_numretrieve("onoff", "value", &value);
	if (value == 0)
		return mes_ok();
	db_numretrieve("clock", "value", &time);
	db_numstore("clock", "value", ++time);
	dest = db_get(belt_name, "dest", db_seq);
	db_numretrieve(belt_name, "length", &length);
	db_numretrieve(belt_name, "N", &N);
	db_numretrieve(belt_name, "in", &in);
	db_numretrieve(belt_name, "out", &out);
	while (out != in) {
		item = mag_index(belt_name, out);
		if (val_null(item))
			val_free(item);
		else {
			sprintf(object, "%s.%d", belt_name, out);
			db_numretrieve(object, "time", &t);
			if (t + length > time) {
				db_clrcache(object);
				val_free(item);
				break;
			}
			mes = mes_alloc(3);
			mes[1] = val_sstr("iput", 0);
			mes[2] = db_get(object, "product", db_seq);
			mes_send_request(val_ref(dest), mes, mag_reply);
			db_clrcache(object);
			mag_strnum(object, out);
			db_store(belt_name, object, (char *) 0); 
			db_numstore(belt_name, "out", out);
		}
		if (++out == N)
			out = 0;
	}
	val_free(dest);
	return mes_ok();
}

struct value **belt_put(req)
struct value **req;
{
	int N, in;
	char buf[32], object[32];

	db_numretrieve(belt_name, "N", &N);
	db_numretrieve(belt_name, "in", &in);
	sprintf(buf, "%d", in);
	sprintf(object, "%s.%d", belt_name, in);
	db_store(belt_name, buf, object);
	db_put(object, "product", req[2]);
	db_put(object, "time", db_get("clock", "value", db_seq));
	db_clrcache(object);
	db_numstore(belt_name, "in", (in + 1) % N);
	return mes_ok();
}

belt_init(name)
char *name;
{
	belt_name = name;
	mag_init(name);
	fac_register();
	mes_subscribe("iput", belt_put);
	mes_subscribe("update", belt_update);
}

main(argc, argv)
char **argv;
{
	belt_init(argv[1]);
	win_main_loop();
	mag_exit(0);
}
