/*
 * Dialer support for Telebit Trailblazer Plus modem.
 */
#include "tip.h"

#define SYNC 1
#define NOSYNC 0

static jmp_buf Sjbuf;

#define VERB(l, f, s) if (boolean(value(VERBOSE))) fprintf(stderr, f, s)

#define DELAY(n) { int i; for(i=0;i<n*90000;i++); }

#define PRINT(s) fprintf(stderr,s)

static int debug;

char *findl();

char *t16DialOutModes[] = {
	"\rAT E0 V0\r", 
	"\0"
};


char *t16AtnModes[] = {
            "\rAT E0 V0\r", /* attention..*/
            "\0"
            };


char *t16DialInModes[] = {
            "AT E0 V0\r",   /* disconnect */
            "\0"
            };


int t16gotok();

extern alarmtr();

/*
** On entry:
**
** FD - file descriptor
**
*/

t16_dialer(num, acu)
register char	*num;
char	*acu;
{
	int ix, retry;
	char buf[BUFSIZ];

	int sp;

#ifdef DEBUG
	debug++;
#endif

	ttysetup(speed(9600));

    ix = 1; retry = 3;

    while (1)
    {

            VERB(4,"Checking for life...\n",acu);


			if (BlatStrings(FD,t16AtnModes,SYNC)) 
				break;

            VERB(4,"BREAK down ...\n",0);
            ioctl(FD,TIOCSBRK,0);
            sleep(1);
            ioctl(FD,TIOCCBRK,0); DELAY(1);
            VERB(4,"BREAK up...\n",0);
			DELAY(1);

            if (--retry == 0) {
                VERB(4,acu, "modem not responding OK");
                t16_disconnect();
                return 0;
            }

            switch(retry)
            {
            case 2:
                ttysetup(speed(2400));
                break;

            case 1:
                ttysetup(speed(1200));
                break;

            default:
                break;
            }


    }

    ttysetup(speed(9600));


    VERB(4,"Checking for life at 9600...\n",0);

    if (!BlatStrings(FD,t16AtnModes,SYNC)) {
        t16_disconnect();
        return 0;
    }

    if (!BlatStrings(FD,t16DialOutModes,SYNC)) {
        t16_disconnect();
        return 0;
    }


    ioctl(FD, TIOCFLUSH, &ix);
    alarm(0);

	sprintf(buf,"ATDT%s\r",num);

	VERB(4,"\r\n",0);
	VERB(4,buf,0);
	VERB(4,"\r\n",0);

	write(FD,buf,strlen(buf));

    if (setjmp(Sjbuf)) {
    	fprintf(stderr,"\nModem Didn't respond after dial command\n");
        t16_disconnect();
    	return 0;
    }

	sp = 0;

    do {

	int result = 0;

    switch (result = t16gotok(FD,60)) {

        case 0: 
    	    VERB(4,"TELEBIT Command accepted\n",0); 
            sp = 0;
            break;
        case 1: 
            PRINT("TELEBIT connected at 300 baud\n");
            sp = 300;
            break;
        case 2: 
            sp = 0;
            VERB(4, "TELEBIT This End Ring\n",0);
            break;
        case 3: 
            PRINT("TELEBIT No Carrier\n");
            sp = -1;
            break;
        case 4: 
            PRINT("TELEBIT Error\n");
            sp = -1;
            break;
        case 5: 
            sp = 1200;
            PRINT("TELEBIT Connect 1200\n");
            break;
        case 6: 
            PRINT("TELEBIT No dialtone\n");
            sp = -1;
            break;
        case 7: 
            PRINT("TELEBIT detected BUSY\n");
            sp = -1;
            break;
        case 8: 
            PRINT("TELEBIT No quiet answer\n");
            sp = -1;
            break;
        case 10: 
            sp = 2400;
            PRINT("TELEBIT Connect 2400\n");
            break;

		case 11:
			sp = 4800;
			PRINT("TELEBIT Connect 4800/V.32\n");
			break;

		case 12:
			sp = 9600;
			PRINT("TELEBIT Connect 9600/V.32\n");
			break;

		case 13:
			sp = 14400;
			PRINT("TELEBIT Connect 14400/V.32\n");
			break;


		case 14:
			sp = 19200;
			PRINT("TELEBIT Connect 19200/V.32\n");
			break;


		case 15:
			sp = 38400;
			PRINT("TELEBIT Connect 38400/V.32\n");
			break;


		case 48:
			sp = 7200;
			PRINT("TELEBIT Connect 7200/V.32\n");
			break;

		case 49:
			sp = 12000;
			PRINT("TELEBIT Connect 12000/V.32\n");
			break;

        case 50:
            sp = 9600;
            PRINT("TELEBIT Connect FAST\n");
            break;

        case 52:
            sp = 0;
            PRINT("TELEBIT Far End  RINGING\n");
            break;


        case 53:
            sp = 0;
            PRINT("TELEBIT Dialing...\n");
            break;


        case 54:
            sp = 0;
            PRINT("TELEBIT No prompttone...\n");
            break;

        case 20:
            PRINT("TELEBIT Connect 300/REL\n");
            sp = 300;
            break;

        case 22:
            PRINT("TELEBIT Connect 1200/REL\n");
            sp = 1200;
            break;

        case 23:
            PRINT("TELEBIT Connect 2400/REL\n");
            sp = 2400;
            break;

		case 24:
			PRINT("TELEBIT Connect 4800/REL\n");
			sp = 4800;
			break;

		case 25:
			PRINT("TELEBIT Connect 9600/REL\n");
			sp = 9600;
			break;

        case 61:
            PRINT("TELEBIT Connect FAST/KERM\n");
            sp = 9600;
            break;

        case 62:
            PRINT("TELEBIT Connect FAST/XMDM\n");
            sp = 9600;
            break;

        case 63:
            PRINT("TELEBIT Connect FAST/UUCP\n");
            sp = 9600;
            break;

        case 71:
            PRINT("TELEBIT Connect FAST/KERM/COMP\n");
            sp = 9600;
            break;

        case 72:
            PRINT("TELEBIT Connect FAST/XMDM/COMP\n");
            sp = 9600;
            break;

        case 73:
            PRINT("TELEBIT Connect FAST/UUCP/COMP\n");
            sp = 9600;
            break;

        default: 
            fprintf(stderr,"TELEBIT Unknown response: <%d>\n",result);
            sp = -1;
            break;
        }

    } while (sp == 0);

    alarm(0);

    if (sp < 0) {
        	t16_disconnect();
            return 0;
    }


	ttysetup(speed(sp));
    return 1;
}


t16_disconnect()
{
	(void) close(FD);
}


t16_abort()
{
	t16_disconnect();
}



t16expstr(fn,str)
register char *str;
int fn;
{
    char buf[BUFSIZ];
    char *cp;
    char *cp1;
    int i;
    int count;
    int gotit = 0;
    int alarms = 15;

    /* while not time outs */
    if (setjmp(Sjbuf))
        goto gotsum;

    signal(SIGALRM, alarmtr);

    /* read characters */
    cp = buf;
again:
    alarm (3);
    count = read(fn, cp, BUFSIZ);
    VERB (4,"Expect: ..count = %d\r\n",count);

gotsum:
    VERB (4,"Expect : gotit = %d\r\n",gotit );
    alarm (0);
    cp += count;
    if (!gotit && findl(str,buf,cp-buf))
    {
        gotit++;
        VERB (4,"Got a match\r\n",0);
        return (1);
    }

    if (!alarms--)
    {
        fprintf  (stderr,"Expect: Timeout.\r\n",0);
        return (0);
    }

    goto again;
}


/*
** findl  - first occurance of pattern in area, returns pointer to
**     character following match in str or null if on fail
**         length specifies length of area.
 */

char *findl(pattern,area,len)
char *pattern, *area;
int len;
{
    char *lastmatch, *pat;
    char *ar;
    int i;

    VERB (4,"Findl: len = %d\r\n",len);
    VERB (4,"Findl: pattern: %s\r\n",pattern);
    VERB (4,"Findl: area = ",0);
    for (ar = area; ar < (area + len);ar++)
        VERB (4,"%c",*ar);

    VERB (4,"\r\n",0);

    ar = area;

    for (;;)
    {
        /* find first match */
        while((ar < (area + len))  && *ar != *pattern ) ar++;

        /*
         * Remember location in area incase match fails and
         * we have to go back.
         */
        lastmatch = ar;
        pat = pattern;

        while (*ar == *pat)
        {
            ar++;
            pat++;
            if (!*pat)
                return (ar); /*found*/

            if( ar > (area+len))
                return ((char *)0);  /* not found*/
        }
        /* no match yet, back up and keep looking */
        pat = pattern;
        ar = lastmatch;
        *ar++;
    }
}




/*
** wait for ack if sync != 0
*/
BlatStrings(fd,sp,sync)
int fd;
int sync;
char **sp;
{
	int touts = 0;
	int result;

	char *cp;

    while(**sp != '\0')
    {
        VERB(4,*sp,0);
        VERB(4,"\n",0);

		cp = *sp;

		while (*cp) {
        	write(fd,cp,1);
			if (*cp == '\r') DELAY(1);
			cp++;
		}

		if (!sync)
			return 1;
			

		result = t16gotok(fd,3);

		if (result == 0) *sp++; 

		if (result != 0) {
	
			if (touts++ > 3) 
                return 0;
		}

    }	 

	return 1;

}


/*
** t16gotok(fd,pd)
**
** look for some response from mr. modem. fd is file 
*/
t16gotok(fd,pd)
int fd,pd;
{
	char buf[80];
	int i;

	if (!pd) pd = 5;

	i = 0;

   	signal(SIGALRM, alarmtr);

	while(1) {

		if (setjmp(Sjbuf)) {
				VERB(4,"\r\nt16gotok(): Timeout.\r\n",0);
				return -1;
		}

		alarm(pd);

		read(fd,&buf[i],1);

		alarm(0);

		buf[i] &= 0177;

		VERB(4, buf[i] >= 040 ? "%c" : "\\%03o", buf[i]);

		if (buf[i] == '\r') {
			VERB(4,"\n",0);
			break;
		}

		if (i++ >= 80) break; 

	}

	/*
	** check for previous character either numeric of 'K'
	*/

	if (i >= 2 && buf[i-1] == 'K' && buf[i-2] == 'O') return 0;

	if (i >= 2 && buf[i-1] >= '0' && buf[i-1] <= '9' && 
	              buf[i-2] >= '0' && buf[i-2] <= '9') {

			buf[i] = '\0';

			return atoi(&buf[i-2]);
	}

	if (i >= 1 && buf[i-1] >= '0' && buf[i-1] <= '9') return buf[i-1] - 060;


	return 1;

}

