/**************************************************************************/
/*       Copyright(c) 1987, 1992 by BBN Systems and Technologies,         */
/*         A Division of Bolt Beranek and Newman Inc.                     */
/*                                                                        */
/*       RDP implementation for 4.2/4.3bsd by Craig Partridge             */
/*                                                                        */
/*  Permission to use, copy, modify, distribute, and sell this software   */
/*  and its documentation for any purpose is hereby granted without fee,  */
/*  provided that the above copyright notice and this permission appear   */
/*  in all copies and in supporting documentation, and that the name of   */
/*  Bolt Beranek and Newman Inc.  not be used in advertising or           */
/*  publicity pertaining to distribution of the software without          */
/*  specific, written prior permission. BBN makes no representations      */
/*  about the suitability of this software for any purposes.  It is       */
/*  provided "AS IS" without express or implied warranties.               */
/**************************************************************************/

/**************************************************************************/
/*                   rdp internal variables                               */
/**************************************************************************/

/*
 * RDP states: RDP_DRAIN is a pseudo-state we hit if user closes with
 * data still to be acked in the outbound queue -- we sit in RDP_DRAIN
 * until the data is acked or timed out.  This because RDP requires that
 * user only close on quiet connection -- and it turns out to be easier
 * for the kernel to do that than the user.
 */

#define R_LISTEN  	1
#define R_OPEN	  	2
#define R_CLOSED  	3
#define R_SYN_SENT 	4
#define R_SYN_RCVD 	5
#define R_CLOSE_WAIT	6
#define R_DRAIN		7

/*
 * Queue sizes.  If you want to make them larger, consider sticking
 * the input queue in the rdpcb and leaving the output queue in the
 * rdpque structure.
 */

#define R_MAXSND	10
#define R_RCVMAX	5
#define R_RCVWIN	(R_RCVMAX * 2)

/*
 * timer constants.  See RFC 889 for details on some of them.
 * note that some are wired into rdp_newrtt().
 */

#define RT_G		(2)


#define RT_RTMAX        (120 * 2)	 /* max round trip time */
#define RT_RTMIN	(1)		 /* 1/2 second min */

/*
 * RT_CLOTIME is added to (current retry interval  * max retries)
 * when we go into close wait.
 */

#define RT_CLOTIME	(RT_RTMAX * 2)	/* wait a long time */
#define RT_NULLTIME	(RT_RTMAX * 2)	/* send null if idle for twice RTMAX */

/*
 * max retries on a particular packet
 */
#define R_MAXTRIES	10

/*
 * the protocol control block.  It is full -- there is no more
 * space in the mbuf to add fields.
 */

struct rdpcb {
    u_long rp_sndnxt;	/* sn of next segment to be sent */
    u_long rp_snduna;	/* sn of oldest unacked segment */
    u_long rp_sndhsa;	/* highest segment acked */

    u_long rp_rcvcur;	/* last seg correct and in order */
    u_long rp_rcvuer;	/* upper edge of rcvwin */
    u_long rp_rcvhi;	/* highest seq received */

    /* sun requires us to do floating point by hand and so everyone does */
    struct rdp_rtt {
	u_short rp_rtt;		/* estimated round-trip time */
	u_short rp_rttfrac;	/* fractional bits of rtt estimate */
    } rp_srtt;

#define rp_estrtt rp_srtt.rp_rtt

    struct rdpque *rp_rq;	/* the queues */

    short rp_timer;	/* user/close/syn timer -- counts down */

    /* buffer control */
    u_short rp_sndmax;  /* max number of packets in flight */
    u_short rp_sndbuf;	/* max send buffer size -- adjusted for IP/RDP header */
    u_short rp_inflt;	/* number of packets in flight and max in flight */
    u_short rp_maxinflt;

    /* quench control values */
    short rp_qwait;	/* how many packets cleared til maxinflt increased? */

    u_char rp_state;	/* rdp state */

    /* some interesting values to have around */

    short rp_lastrtt;	/* most recent rtt */
    short rp_datsegs;	/* # of data segments sent */
    short rp_qcnt;	/* number of quenchs recv'd */
} ;

/*
 * RDP sending and receiving queues.
 */

struct rdpque {
    struct mbuf *rq_rcvq[R_RCVWIN];	/* rcv queue */
    struct mbuf *rq_sndq[R_MAXSND];	/* send queue */
    short rq_sndtimer[R_MAXSND];	/* send timers -- count up */
    u_char rq_retries[R_MAXSND];	/* retry counters */
    u_char rq_rcvbase;			/* pointer into circular queues */
    u_char rq_sndbase;			/* pointer into circular queues */
};


struct rdpstats {
    long rst_ipackets;	/* total input packets */
    long rst_opackets;	/* total output packets */
    long rst_nulls;	/* null keepalives sent */
    long rst_fullwin;	/* times we filled a window */
    long rst_hitedge;	/* times we filled our send buffers */
    long rst_retrans;	/* times we had to retransmit */

    /* types of dropped packets */
    long rst_cksum;	/* checksum bad */
    long rst_dup;	/* duplicated */
    long rst_range;	/* out of range -- duplicate or window overrun */
    long rst_len;	/* bad length */

    /* connections timedout */
    long rst_conntimo;
};


#ifdef KERNEL
extern struct rdpstats rdp_info;
#endif
