
/*
 *	$Header: snmpset.c,v 3.0 91/05/17 16:14:52 jrd Rel $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <stdio.h>
#include        <netdb.h>
#include        <signal.h>

#include	<host.h>

#include	<ctypes.h>
#include	<rdx.h>
#include	<debug.h>
#include	<smp.h>
#include	<aps.h>
#include	<ap0.h>
#include	<asn.h>
#include	<asl.h>
#include	<smx.h>
#include	<udp.h>

#define		cmdBufferSize		(2048)
#define		cmdBindListSize		(20)
#define		cmdTextSize		(128)

static		SmpSequenceType		requestId;
static		CBoolType		cmdDone;

static	void	cmdInit ()

{
	aslInit ();
	asnInit ();
	apsInit ();
	ap0Init ();
	smpInit ();
}

static  SmpStatusType   myUpCall (smp, req)

SmpIdType               smp;
SmpRequestPtrType       req;

{
	SmpIndexType		i;
	SmpBindPtrType		bind;
	CCharType		text [ (cmdTextSize + 1) ];

        smp = smp;
	if ((req->smpRequestCmd != smpCommandRsp) ||
		(req->smpRequestId != requestId)) {
		return (errOk);
	}

	cmdDone = TRUE;

	printf ("Request Id: %d\n", req->smpRequestId);
	printf ("Error: %s\n", smxErrorToText (req->smpRequestError));
	printf ("Index: %d\n", req->smpRequestIndex);
	printf ("Count: %d\n", req->smpRequestCount);
	printf ("\n");

	bind = req->smpRequestBinds;
	for (i = req->smpRequestCount; i != 0; i--) {
		if (smxNameToText (text, (CIntfType) cmdTextSize,
			(CBytePtrType) bind->smpBindName,
			(CIntfType) bind->smpBindNameLen) >=
			(CIntfType) 0) {
			printf ("Name: %s\n", text);
		}
		printf ("Kind: %s\n", smxKindToText (bind->smpBindKind));
		if (smxValueToText (text, (CIntfType) cmdTextSize,
			bind) >= (CIntfType) 0) {
			printf ("Value: %s\n", text);
		}
		else {
			printf ("Value: GARBLED\n");
		}
		printf ("\n");
		bind++;
	}
        return (errOk);
}

static	CIntfType	usage (s)

CCharPtrType		s;

{
	fprintf (stderr, "Usage: %s", s);
	fprintf (stderr, " [-h fhost]");
	fprintf (stderr, " [-p fport]");
	fprintf (stderr, " [-t timeout]");
	fprintf (stderr, " [-i requestId]");
	fprintf (stderr, " [-c community]");
	fprintf (stderr, " [name] [type] [value] ...\n");
	return (1);
}

static	int		alarmHandler (sig, code, scp)

int			sig;
int			code;
struct	sigcontext	*scp;

{
	sig = sig;
	code = code;
	scp = scp;
	fprintf (stderr, "Request Timed Out\n");
	(void) fflush (stderr);
	exit (4);
}

int		setCommand (argc, argv)

int		argc;
char		**argv;

{
	int			s;
	int			salen;
	int			result;
	struct	sockaddr	salocal;
	struct	sockaddr	saremote;
	struct	sockaddr_in	*sin;
        struct  servent         *svp;
	unsigned		timeout;
	struct	sigvec		newSignalVector;

	u_long			fhost;
	u_short			fport;
	CUnslType		number;

	CByteType		buf [ cmdBufferSize ];
	CBytePtrType		bp;
	SmpBindType		bindList [ cmdBindListSize ];
	SmpIndexType		bindCount;
	SmpIdType		smp;
	ApsIdType		communityId;
	SmpSocketType		udp;
	SmpRequestType		req;
	SmpBindPtrType		bindp;
	SmpKindType		kind;
	CCharPtrType		*ap;
	CCharPtrType		cp;
	CBoolType		noerror;
	CIntfType		len;
	CIntfType		space;

	CCharPtrType		communityString;
	CCharPtrType		fhostString;
	CCharPtrType		fportString;
	CCharPtrType		requestIdString;
	CCharPtrType		timeoutString;

	communityString = (CCharPtrType) 0;
	fhostString = (CCharPtrType) 0;
	fportString = (CCharPtrType) 0;
	requestIdString = (CCharPtrType) 0;
	timeoutString = (CCharPtrType) 0;

	ap = (CCharPtrType *) argv + 1;
	argc--;
	noerror = TRUE;
	while ((argc != 0) && (**ap == (CCharType) '-') && (noerror)) {
		cp = *ap;
		cp++;
		ap++;
		argc--;
		while ((*cp != (CCharType) 0) && (noerror)) {
			switch (*cp) {

			case 'c':
				argc--;
				communityString = *ap++;
				break;

			case 'h':
				argc--;
				fhostString = *ap++;
				break;

			case 'i':
				argc--;
				requestIdString = *ap++;
				break;

			case 'p':
				argc--;
				fportString = *ap++;
				break;

			case 't':
				argc--;
				timeoutString = *ap++;
				break;

			default:
				noerror = FALSE;
				break;
			}
			cp++;
		}
	}

	if ((! noerror) || (fhostString == (CCharPtrType) 0)) {
		return ((int) usage ((CCharPtrType) argv [ 0 ]));
	}

	if ((argc / 3 > cmdBindListSize) || ((argc % 3) != 0)) {
		return ((int) usage ((CCharPtrType) argv [ 0 ]));
	}

	fhost = (u_long) hostAddress (fhostString);
	if (fhost == (u_long) -1) {
		fprintf (stderr, "%s: Bad foreign host: %s\n",
			argv [ 0 ], fhostString);
		return (2);
	}

	if (fportString != (CCharPtrType) 0) {
                if (rdxDecodeAny (& number, fportString) < (CIntfType) 0) {
                        fprintf (stderr, "%s: Bad local port: %s\n",
                                argv [ 0 ], fportString);
                        return (2);
                }
                else {
                        fport = htons ((u_short) number);
                }
        }
        else {
                svp = getservbyname ("snmp", "udp");
                if (svp == (struct servent *) 0) {
                        fprintf (stderr, "%s: No such service: %s/%s\n",
                                argv [ 0 ], "snmp", "udp");
                        return (2);
                }
                fport = (u_short) svp->s_port;
        }

	if (timeoutString != (CCharPtrType) 0) {
                if (rdxDecodeAny (& number, timeoutString) < (CIntfType) 0) {
                        fprintf (stderr, "%s: Bad timeout value: %s\n",
                                argv [ 0 ], timeoutString);
                        return (2);
                }
		else {
			timeout = (unsigned) number;
		}
	}
	else {
			timeout = (unsigned) 0;
	}

	if (requestIdString != (CCharPtrType) 0) {
                if (rdxDecodeAny (& number, requestIdString) < (CIntfType) 0) {
                        fprintf (stderr, "%s: Bad requestId value: %s\n",
                                argv [ 0 ], requestIdString);
                        return (2);
                }
		else {
			requestId = (SmpSequenceType) number;
		}
	}
	else {
			requestId = (SmpSequenceType) 0;
	}

	if (communityString == (CCharPtrType) 0) {
		communityString = (CCharPtrType) "public";
	}

	cmdInit ();

	bp = buf;
	space = cmdBufferSize;
	bindp = bindList;
	bindCount = (SmpIndexType) 0;

	for (noerror = TRUE; (noerror) && (argc > 0); argc -= 3) {
		if ((len = smxTextToObjectId (bp, space, *ap)) <
			(CIntfType) 0) {
			noerror = FALSE;
		}
		else if ((kind = smxTextToKind (*(++ap))) == smpKindNone) {
			noerror = FALSE;
		}
		else {
			ap++;
			bindp->smpBindName = (SmpNameType) bp;
			bindp->smpBindNameLen = (SmpLengthType) len;
			bindp->smpBindKind = kind;
			bp += len;
			space -= len;
			bindp->smpBindValue = (SmpValueType) bp;
			bindp->smpBindValueLen = (SmpLengthType) space;
			if ((len = smxTextToValue (bindp, *ap)) <
				(CIntfType) 0) {
				noerror = FALSE;
			}
			else {
				ap++;
				space -= len;
				bp += len;
				bindp++;
				bindCount++;
			}
		}
	}

	if (! noerror) {
		fprintf (stderr, "%s: Error parsing argument %s\n",
			argv [ 0 ], *ap);
		return (2);
	}

	s = socket (AF_INET, SOCK_DGRAM, 0);
	if (s < 0) {
		(void) perror ("socket");
		return (1);
	}

	sin = (struct sockaddr_in *) & salocal;
        bzero ((char *) sin, sizeof (*sin));
	sin->sin_family = AF_INET;
	sin->sin_addr.s_addr = (u_long) 0;
	sin->sin_port = (u_short) 0;

	result = bind (s, & salocal, sizeof (*sin));
	if (result < 0) {
		(void) perror ("bind");
		return (1);
	}

        udp = udpNew (s, fhost, fport);
        smp = smpNew (udp, udpSend, myUpCall);
	if (smp == (SmpIdType) 0) {
		fprintf (stderr,
			"%s: Error creating protocol object\n", argv [ 0 ]);
		udp = udpFree (udp);
		return (2);
	}

	communityId = apsNew ((ApsNameType) communityString,
		(ApsNameType) "trivial", (ApsGoodiesType) 0);

	req.smpRequestCmd = smpCommandSet;
	req.smpRequestCommunity = communityId;
	req.smpRequestId = requestId;
	req.smpRequestError = smpErrorNone;
	req.smpRequestIndex = (SmpIndexType) 0;
	req.smpRequestCount = bindCount;
	req.smpRequestBinds = bindList;

	if (smpRequest (smp, & req) != errOk) {
		fprintf (stderr, "%s: Error sending protocol request\n",
			argv [ 0 ]);
		smp = smpFree (smp);
		udp = udpFree (udp);
		communityId = apsFree (communityId);
		return (2);
	}
	smp = smpFree (smp);

	sin = (struct sockaddr_in *) & saremote;

	if (timeout != (unsigned) 0) {
		newSignalVector.sv_handler = alarmHandler;
		newSignalVector.sv_mask = 0;
		newSignalVector.sv_flags = 0;
		if (sigvec (SIGALRM, & newSignalVector,
			(struct sigvec *) 0) == -1) {
			perror (argv [ 0 ]);
			udp = udpFree (udp);
			communityId = apsFree (communityId);
			return (2);
		}
		(void) alarm (timeout);
	}

	do {
        	smp = smpNew (udp, udpSend, myUpCall);
		if (smp == (SmpIdType) 0) {
			fprintf (stderr,
				"%s: Error creating protocol object\n",
				argv [ 0 ]);
			udp = udpFree (udp);
			communityId = apsFree (communityId);
			return (2);
		}

		salen = sizeof (saremote);
		result = recvfrom (s, (char *) buf, (int) cmdBufferSize,
			(int) 0, & saremote, & salen);
		DEBUGBYTES (buf, result);
		DEBUG0 ("\n");

		for (bp = buf; ((result > 0) &&
			(smpInput (smp, *bp++) == errOk));
			result--);

		DEBUG1 ("result: %d\n", result);
		smp = smpFree (smp);

	} while ((result >= 0) && (! cmdDone));

	udp = udpFree (udp);
	communityId = apsFree (communityId);
	return (close (s));
}

int	main (argc, argv)

int     argc;
char    *argv [];

{
        exit (setCommand (argc, argv));
}

