
/*
 *	$Header: if.c,v 3.0 91/05/17 16:14:24 jrd Rel $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<sys/types.h>
#include	<nlist.h>
#include	<sys/mbuf.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#define		KERNEL
#include	<net/if.h>
#undef		KERNEL
#include	<stdio.h>

#include	<ctypes.h>
#include	<error.h>
#include	<debug.h>
#include	<local.h>
#include	<mix.h>
#include	<mis.h>
#include	<asn.h>

#include	<kmem.h>
#include	<if.h>

#define		ifMaxNameSize		(16)

typedef		struct			IfRecTag {

	        struct IfRecTag		*ifRecNext;
		CUnswType		ifRecAddr;
		CIntlType		ifRecIndex;
		CByteType		ifRecName [ ifMaxNameSize ];
		AsnLengthType		ifRecNameLen;
		struct	ifnet		ifRecData;

		}			IfRecType;

typedef		IfRecType		*IfRecPtrType;

typedef		AsnIdType		(*IfGetFnType) ();
typedef		MixStatusType		(*IfSetFnType) ();

typedef		struct			IfCookieTag {

	        MixNamePtrType		ifCookieName;
		MixLengthType		ifCookieNameLen;
	        IfGetFnType		ifCookieGetFn;
	        IfSetFnType		ifCookieSetFn;

                }			IfCookieType;

typedef		IfCookieType		*IfCookiePtrType;

#define	ifVarDefn(a,b,c,d)	\
        { (MixNamePtrType) (a), (MixLengthType) (b), (c), (d) },

static		IfRecPtrType		ifChainHead;
static		CUnswType		ifChainAddr;

static	IfRecPtrType	ifLookUp (head, item)

IfRecPtrType		head;
CIntfType		item;

{
	IfRecPtrType			p;
	CIntfType			i;
	static	CIntfType		cachedItem	=	0;
	static	IfRecPtrType		cachedEntry;

        if (item <= 0) {
		return ((IfRecPtrType) 0);
	}
	else if (item == cachedItem) {
		return (cachedEntry);
	}
	for (i = item; (i > 1) && (head != (IfRecPtrType) 0); i--) {
		head = head->ifRecNext;
	}
	if (head != (IfRecPtrType) 0) {
		cachedItem = item;
		cachedEntry = head;
	}
	return (head);
}

static	IfRecPtrType	ifChainFree (head)

IfRecPtrType		head;

{
	if (head != (IfRecPtrType) 0) {
		head->ifRecNext = ifChainFree (head->ifRecNext);
		(void) free ((char *) head);
	}
	return ((IfRecPtrType) 0);
}

static	CBoolType	ifEntryRefresh (head)

IfRecPtrType		head;

{
	CCharType		nameBuf [ ifMaxNameSize ];

	if (head != (IfRecPtrType) 0) {
		if (kmemRead ((CBytePtrType) & head->ifRecData,
		        (CIntfType) sizeof (head->ifRecData),
			head->ifRecAddr) != (CIntfType) sizeof
		        (head->ifRecData)) {
			return (FALSE);
		}
		else if (kmemRead ((CBytePtrType) nameBuf,
		        (CIntfType) sizeof (nameBuf),
			(CUnswType) head->ifRecData.if_name) != (CIntfType) sizeof
		        (nameBuf)) {
			return (FALSE);
		}
		else {
			*(nameBuf + sizeof (nameBuf)) = (CCharType) 0;
			(void) sprintf ((char *) head->ifRecName,
			        "%s%d", (char *) nameBuf,
				head->ifRecData.if_unit);
			head->ifRecNameLen =
				(AsnLengthType) strlen ((char *) head->ifRecName);
			return (TRUE);
		}
	}
	else {
		return (FALSE);
	}
}

static	IfRecPtrType	ifChainRefresh (location, index)

CUnswType		location;
CIntlType		index;

{
	IfRecPtrType			entry;

	entry = (IfRecPtrType) malloc ((unsigned) sizeof (*entry));
	if (entry == (IfRecPtrType) 0) {
		return (entry);
	}
	entry->ifRecAddr = location;

	if (ifEntryRefresh (entry) != TRUE) {
		(void) free ((char *) entry);
		return ((IfRecPtrType) 0);
	}
	entry->ifRecIndex = index;
	entry->ifRecNext = ifChainRefresh (entry->ifRecData.if_next,
                index + 1);
	return (entry);
}

static	IfRecPtrType	ifTableRefresh (location)

CUnswType		location;

{
	CUnswType		first;

	if (kmemRead ((CBytePtrType) & first,
		(CIntfType) sizeof (first), location) !=
		(CIntfType) sizeof (first)) {
		return ((IfRecPtrType) 0);
	}
	else {
		return (ifChainRefresh (first, (CIntlType) 1));
	}
}

static	AsnIdType	ifRetrieve (mix, item)

IfCookiePtrType		mix;
CIntfType		item;

{
	IfRecPtrType		entry;

	if ((entry = ifLookUp (ifChainHead, item)) ==
	        (IfRecPtrType) 0) {
		return ((AsnIdType) 0);
	}
	else if (ifEntryRefresh (entry)) {
		return ((*mix->ifCookieGetFn) (entry));
	}
	else {
		return ((AsnIdType) 0);
	}
}

static	MixStatusType	ifRelease (cookie)

MixCookieType		cookie;

{
	cookie = cookie;
	return (smpErrorGeneric);
}

static	MixStatusType	ifCreate (cookie, name, namelen, asn)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		asn;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	asn = asn;
	return (smpErrorGeneric);
}

static	MixStatusType	ifDestroy (cookie, name, namelen)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	return (smpErrorGeneric);
}

static	AsnIdType	ifGet (cookie, name, namelen)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;

{
	if (namelen != (MixLengthType) 1) {
		return ((AsnIdType) 0);
	}
	else {
		return (ifRetrieve ((IfCookiePtrType) cookie,
                        (CIntfType) *name));
	}
}

static	MixStatusType	ifSet (cookie, name, namelen, asn)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		asn;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	asn = asn;
	return (smpErrorGeneric);
}

static	AsnIdType	ifNext (cookie, name, namelenp)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthPtrType	namelenp;

{
	CIntfType		item;

	if (*namelenp == (MixLengthType) 0) {
		*namelenp = (MixLengthType) 1;
		*name = (MixNameType) 1;
		return (ifRetrieve ((IfCookiePtrType) cookie, (CIntfType) 1));
	}
	else {
		item = (CIntfType) *name;
		*namelenp = (MixLengthType) 1;
		*name = (MixNameType) (++item);
		return (ifRetrieve ((IfCookiePtrType) cookie, item));
	}
}

static	MixOpsType	ifOps = {

			ifRelease,
			ifCreate,
			ifDestroy,
			ifNext,
			ifGet,
			ifSet

			};

static	MixStatusType		ifSetUnsupported ()

{
	return (smpErrorNone);
}

static	AsnIdType		ifGetUnsupported (entry)

IfRecPtrType			entry;

{
	return (asnIntl (asnClassUniversal, (AsnTagType) 2,
	        (CIntlType) 0));
}

static	AsnIdType		ifIndexGet (entry)

IfRecPtrType			entry;

{
	return (asnIntl (asnClassUniversal, (AsnTagType) 2,
	        entry->ifRecIndex));
}

static	AsnIdType		ifDescrGet (entry)

IfRecPtrType			entry;

{
	return (asnOctetString (asnClassUniversal, (AsnTagType) 4,
	        entry->ifRecName, entry->ifRecNameLen));
}

static	AsnIdType		ifMtuGet (entry)

IfRecPtrType			entry;

{
	return (asnIntl (asnClassUniversal, (AsnTagType) 2,
	        (CIntlType) entry->ifRecData.if_mtu));
}

static	AsnIdType		ifSpeedGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 2,
	        (CUnslType) 0));
}

static	AsnIdType		ifPhysAddressGet (entry)

IfRecPtrType			entry;

{
	return (asnOctetString (asnClassUniversal, (AsnTagType) 4,
	        entry->ifRecName, (AsnLengthType) 0));
}

static	AsnIdType		ifAdminStatusGet (entry)

IfRecPtrType			entry;

{
	CIntlType		result;

	result = (entry->ifRecData.if_flags & IFF_UP) ? 1 : 2;
	return (asnIntl (asnClassUniversal, (AsnTagType) 2,
	        result));
}

static	AsnIdType		ifLastChangeGet (entry)

IfRecPtrType			entry;

{
	return (asnIntl (asnClassApplication, (AsnTagType) 3,
	        (CIntlType) 0));
}

static	AsnIdType		ifInOctetsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) 0));
}

static	AsnIdType		ifInUcastPktsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) entry->ifRecData.if_ipackets));
}

static	AsnIdType		ifInErrorsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) entry->ifRecData.if_ierrors));
}

static	AsnIdType		ifOutUcastPktsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) entry->ifRecData.if_opackets));
}

static	AsnIdType		ifOutDiscardsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) entry->ifRecData.if_snd.ifq_drops));
}

static	AsnIdType		ifOutErrorsGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 1,
	        (CUnslType) entry->ifRecData.if_oerrors));
}

static	AsnIdType		ifOutQLenGet (entry)

IfRecPtrType			entry;

{
	return (asnUnsl (asnClassApplication, (AsnTagType) 2,
	        (CUnslType) entry->ifRecData.if_snd.ifq_len));
}

static	AsnIdType		ifSpecificGet (entry)

IfRecPtrType			entry;

{
	return (asnObjectId (asnClassUniversal, (AsnTagType) 6,
	        (CBytePtrType) "\0", (AsnLengthType) 1));
}

#define		ifTypeGet		ifGetUnsupported
#define		ifOperStatusGet		ifAdminStatusGet
#define		ifInNUcastPktsGet	ifInOctetsGet
#define		ifInDiscardsGet		ifInOctetsGet
#define		ifInUnknownProtosGet	ifInOctetsGet
#define		ifOutOctetsGet		ifInOctetsGet
#define		ifOutNUcastPktsGet	ifInOctetsGet

static	IfCookieType		ifVarTable [] = {

	ifVarDefn ("\53\6\1\2\1\2\2\1\1", 9, ifIndexGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\2", 9, ifDescrGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\3", 9, ifTypeGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\4", 9, ifMtuGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\5", 9, ifSpeedGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\6", 9, ifPhysAddressGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\7", 9, ifAdminStatusGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\10", 9, ifOperStatusGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\11", 9, ifLastChangeGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\12", 9, ifInOctetsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\13", 9, ifInUcastPktsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\14", 9, ifInNUcastPktsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\15", 9, ifInDiscardsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\16", 9, ifInErrorsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\17", 9, ifInUnknownProtosGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\20", 9, ifOutOctetsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\21", 9, ifOutUcastPktsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\22", 9, ifOutNUcastPktsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\23", 9, ifOutDiscardsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\24", 9, ifOutErrorsGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\25", 9, ifOutQLenGet, ifSetUnsupported)
	ifVarDefn ("\53\6\1\2\1\2\2\1\26", 9, ifSpecificGet, ifSetUnsupported)

	ifVarDefn (0, 0, ifGetUnsupported, ifSetUnsupported)
};

CVoidType		ifInit ()

{
	CIntfType			i;
	struct		nlist		nl [ 4 ];
	IfCookiePtrType			cp;

	nl [ 0 ].n_name = "_ifnet";
	nl [ 1 ].n_name = (char *) 0;
	if (nlist ("/vmunix", nl) != 0) {
		return;
	}
	ifChainAddr = (CUnslType) nl [ 0 ].n_value;
	ifChainHead = ifTableRefresh (ifChainAddr);

	for (cp = ifVarTable; cp->ifCookieName != (MixNamePtrType) 0;
                cp++) {
		(void) misExport (cp->ifCookieName, cp->ifCookieNameLen,
		& ifOps, (MixCookieType) cp);
	}
}
