
/*
 *	$Header: icmp.c,v 3.0 91/05/17 16:14:18 jrd Rel $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<sys/types.h>
#include	<netinet/in.h>
#include	<netinet/in_systm.h>
#include	<netinet/ip.h>
#include	<netinet/ip_icmp.h>
#include	<netinet/icmp_var.h>
#include	<nlist.h>

#include	<ctypes.h>
#include	<error.h>
#include	<local.h>
#include	<icmp.h>
#include	<mix.h>
#include	<mis.h>
#include	<asn.h>

#include	<kmem.h>

static	CUnslType		icmpAddr;
static	char			*icmpXlate = "\3\13\14\4\5\10\0\15\16\21\22";

static	AsnIdType	icmpRetrieve (item)

CIntfType		item;

{
	struct	icmpstat	statBuf;
	CUnslType		counter;
	AsnIdType		result;
	CIntfType		i;

	if (kmemRead ((CBytePtrType) & statBuf, (CIntfType) sizeof (statBuf),
		icmpAddr) != (CIntfType) sizeof (statBuf)) {
		result = (AsnIdType) 0;
	}
	else {
		if (item == (CIntfType) 1) {
			counter = (CUnslType) 0;
			counter += (CUnslType) statBuf.icps_badcode;
			counter += (CUnslType) statBuf.icps_tooshort;
			counter += (CUnslType) statBuf.icps_checksum;
			counter += (CUnslType) statBuf.icps_badlen;
			for (i = 0; i < ICMP_MAXTYPE; i++) {
				counter += (CUnslType)
					statBuf.icps_inhist [ i ];
			}
		}
		else if (item == (CIntfType) 2) {
			counter = (CUnslType) 0;
			counter += (CUnslType) statBuf.icps_badcode;
			counter += (CUnslType) statBuf.icps_tooshort;
			counter += (CUnslType) statBuf.icps_checksum;
			counter += (CUnslType) statBuf.icps_badlen;
		}
		else if (item < (CIntfType) 14) {
			counter = (CUnslType) statBuf.icps_inhist
				[ (int) icmpXlate [ (int) item - 3 ] ];
		}
		else if (item == (CIntfType) 14) {
			counter = (CUnslType) 0;
			counter += (CUnslType) statBuf.icps_error;
			counter += (CUnslType) statBuf.icps_oldicmp;
			for (i = 0; i < ICMP_MAXTYPE; i++) {
				counter += (CUnslType)
					statBuf.icps_inhist [ i ];
			}
		}
		else if (item == (CIntfType) 15) {
			counter = (CUnslType) 0;
			counter += (CUnslType) statBuf.icps_error;
			counter += (CUnslType) statBuf.icps_oldicmp;
		}
		else {
			counter = (CUnslType) statBuf.icps_outhist
				[ (int) icmpXlate [ (int) item - 16 ] ];
		}

		result = asnUnsl (asnClassApplication, (AsnTagType) 1,
			counter);
	}

	return (result);
}

static	MixStatusType	icmpRelease (cookie)

MixCookieType		cookie;

{
	cookie = cookie;
	return (smpErrorGeneric);
}

static	MixStatusType	icmpCreate (cookie, name, namelen, asn)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		asn;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	asn = asn;
	return (smpErrorGeneric);
}

static	MixStatusType	icmpDestroy (cookie, name, namelen)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	return (smpErrorGeneric);
}

static	AsnIdType	icmpGet (cookie, name, namelen)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;

{
	CIntfType		item;

	cookie = cookie;
	if ((namelen != (MixLengthType) 2) ||
		((item = (CIntfType) *name) < (CIntfType) 1) ||
		(item > (CIntfType) 26) || (*(name + 1) != (MixNameType) 0)) {
		return ((AsnIdType) 0);
	}
	else {
		return (icmpRetrieve (item));
	}
}

static	MixStatusType	icmpSet (cookie, name, namelen, asn)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthType		namelen;
AsnIdType		asn;

{
	cookie = cookie;
	name = name;
	namelen = namelen;
	asn = asn;
	return (smpErrorReadOnly);
}

static	AsnIdType	icmpNext (cookie, name, namelenp)

MixCookieType		cookie;
MixNamePtrType		name;
MixLengthPtrType	namelenp;

{
	CIntfType		item;

	cookie = cookie;
	if (*namelenp == (MixLengthType) 0) {
		*namelenp = (MixLengthType) 2;
		*name++ = (MixNameType) 1;
		*name = (MixNameType) 0;
		return (icmpRetrieve ((CIntfType) 1));
	}
	else if (*namelenp == (MixLengthType) 1) {
		if ((item = (CIntfType) *name) <= (CIntfType) 26) {
			*namelenp = (MixLengthType) 2;
			*(++name) = (MixNameType) 0;
			return (icmpRetrieve (item));
		}
		else {
			return ((AsnIdType) 0);
		}
	}
	else if ((item = (CIntfType) *name) < (CIntfType) 26) {
		*namelenp = (MixLengthType) 2;
		*name++ = (MixNameType) (++item);
		*name = (MixNameType) 0;
		return (icmpRetrieve (item));
	}
	else {
		return ((AsnIdType) 0);
	}
}

static	MixOpsType	icmpOps = {

			icmpRelease,
			icmpCreate,
			icmpDestroy,
			icmpNext,
			icmpGet,
			icmpSet

			};

CVoidType		icmpInit ()

{
	struct		nlist		nl [ 2 ];

	nl [ 0 ].n_name = "_icmpstat";
	nl [ 1 ].n_name = (char *) 0;
	if (nlist ("/vmunix", nl) == 0) {
		icmpAddr = (CUnslType) nl [ 0 ].n_value;
		(void) misExport ((MixNamePtrType) "\53\6\1\2\1\5",
			(MixLengthType) 6, & icmpOps, (MixCookieType) 0);
	}
}

