
/*
 *	$Header: smptest.c,v 3.0 91/05/17 16:15:21 jrd Rel $
 *	Author: J. Davin
 *	Copyright 1988, 1989, Massachusetts Institute of Technology
 *	See permission and disclaimer notice in file "notice.h"
 */

#include	<notice.h>

#include	<strings.h>

#include	<ctypes.h>
#include	<rdx.h>
#include	<debug.h>
#include	<smp.h>
#include	<smx.h>
#include	<mis.h>
#include	<miv.h>
#include	<aps.h>
#include	<avl.h>
#include	<ap0.h>
#include	<asn.h>

#define		cmdStringSize		(32)

ApsIdType	smpPublic;

CIntlType	smpVar0;
CIntlType	smpVar1;
CUnslType	smpVar2;
CUnslType	smpVar3;
CUnslType	smpVar4;
CUnslType	smpVar5;
CUnslType	smpVar6;
CUnslType	smpVar7;

MivStrType	smpVar8;
CByteType	smpBuf8 [ cmdStringSize ];

MivStrType	smpVar9;
CByteType	smpBuf9 [ cmdStringSize ];

CByteType	smpVar10 [ cmdStringSize ];

static	int		mainInit ()

{
	aslInit ();
	asnInit ();
	misInit ();
	avlInit ();
	mixInit ();
	apsInit ();
	ap0Init ();
	smpInit ();

	(void) mivIntlRW ((MixNamePtrType) "\53\6\1\2\1\1\0",
		(MixLengthType) 7, & smpVar0);
	smpVar0 = (CIntlType) 7;
	(void) mivIntlRW ((MixNamePtrType) "\53\6\1\2\1\1\1",
		(MixLengthType) 7, & smpVar1);
	smpVar1 = (CIntlType) -7;

	(void) mivUnslRW ((MixNamePtrType) "\53\6\1\2\1\1\2",
		(MixLengthType) 7, & smpVar2);
	smpVar2 = (CUnslType) 8;
	(void) mivUnslRW ((MixNamePtrType) "\53\6\1\2\1\1\3",
		(MixLengthType) 7, & smpVar3);
	smpVar3 = (CUnslType) -8;

	(void) mivCounterRW ((MixNamePtrType) "\53\6\1\2\1\1\4",
		(MixLengthType) 7, & smpVar4);
	smpVar4 = (CUnslType) 9;
	(void) mivCounterRW ((MixNamePtrType) "\53\6\1\2\1\1\5",
		(MixLengthType) 7, & smpVar5);
	smpVar5 = (CUnslType) -9;

	(void) mivGuageRW ((MixNamePtrType) "\53\6\1\2\1\1\6",
		(MixLengthType) 7, & smpVar6);
	smpVar6 = (CUnslType) 10;
	(void) mivGuageRW ((MixNamePtrType) "\53\6\1\2\1\1\7",
		(MixLengthType) 7, & smpVar7);
	smpVar7 = (CUnslType) -10;

	(void) mivStringRW ((MixNamePtrType) "\53\6\1\2\1\1\8",
		(MixLengthType) 7, & smpVar8);
	(void) strcpy ((char *) smpBuf8, "hello, world!");
	smpVar8.mivStrData = smpBuf8;
	smpVar8.mivStrLen = (CUnsfType) strlen ((char *) smpBuf8);
	smpVar8.mivStrMaxLen = (CUnsfType) cmdStringSize;

	(void) mivObjectIdRW ((MixNamePtrType) "\53\6\1\2\1\1\11",
		(MixLengthType) 7, & smpVar9);
	smpVar9.mivStrData = smpBuf9;
	smpVar9.mivStrLen = (CUnsfType) smxTextToObjectId (smpBuf9,
		(CIntfType) cmdStringSize, "1.3.6.1.2.1.1.1.0");
	smpVar9.mivStrMaxLen = (CUnsfType) cmdStringSize;

	(void) mivIPAddrRW ((MixNamePtrType) "\53\6\1\2\1\1\12",
		(MixLengthType) 7, smpVar10);
	(void) smxTextToIPAddr (smpVar10, (CIntfType) cmdStringSize,
		"18.26.0.99");

	smpPublic = apsNew ((ApsNameType) "public", (ApsNameType) "trivial",
		(ApsGoodiesType) 0);
	return (0);
}

static	SmpStatusType	mySend (s, cp, n)

SmpSocketType		s;
CBytePtrType		cp;
CIntfType		n;

{
	printf ("mySend:\n");
	s = s;
	while (n-- > 0) {
		printf ("%02.02X ", *cp++);
	}
	printf ("\n");
	return (errOk);
}

int	main (argc, argv)

int	argc;
char	*argv [];

{
	SmpIdType		smp;
	SmpStatusType		status;
	CByteType		buf [ 512 ];
	CBytePtrType		cp;
	CIntfType		i;
	CUnslType		number;

	cp = buf;
	for (i = 1; i < (CIntfType) argc; i++) {
		(void) rdxDecodeAny (& number, argv [ i ]);
		*cp++ = (CByteType) number;
	}

	(void) mainInit ();

	smp = smpNew ((SmpSocketType) 0, mySend, (SmpHandlerType) 0);

	status = errOk;
	cp = buf;
	for (i = 1; ((status == errOk) && (i < (CIntfType) argc)); i++) {
		status = smpInput (smp, *cp);
		DEBUG2 ("%02.02X %d\n", (unsigned) *cp, status);
		cp++;
	}

	switch (status) {

	case errOk:
		DEBUG0 ("++OK\n");
		break;

	case errBad:
		DEBUG0 ("++BAD\n");
		break;

	default:
		DEBUG0 ("++Panic\n");
		break;
	}

	smp = smpFree (smp);
	exit (0);
}
