/*
 * Initialize data structures that might otherwise be initialized
 * at compile time, but for re-startable RAM code, must be at run-time.
 *
 * (c) Copyright 1986, Kinetics, Inc.
 * May be used but not sold without permission.
 *
 * $Header: init.c,v 4.1 88/11/01 19:49:58 sw0l Locked $
 */

#include "gw.h"
#include "fp/pbuf.h"
#include "ab.h"
#include "ether.h"
#include "inet.h"
#include "ie.h"
#include "gwctl.h"
#include "fp/cmdmacro.h"

#include "glob.h"

/* from ie.c */
/*
 * Configuration command data (from page 4-5 of NI3210 manual).
 */
struct cb ieconf_proto = {
  SWAB(0),			/* status */
  SWAB(CB_EL|CBC_CONFIG),	/* cmd */
  SWAB(0xffff),			/* link to next (none) */
  SWAB(0x020c),			/* FIFO thresshold is 2 */
				/* 12 byte parameter list */
  SWAB(0x2ec0),			/* 8 byte preamble */
				/* address and data type in data */
				/* 6 ethernet address bytes */
				/* store bad frames in memory */
				/* srdy/ardy pin opertes as srdy */
  SWAB(0x6000),			/* 0x60 Interframe spacing in TxC time units */
				/* 802.3 Exponential Backoff */
  SWAB(0xf200),			/* 16 retries on xmit collision */
				/* slot time: 0x200 */
  SWAB(0x0400),			/* Collision Detect Source: external */
				/* Carrier Sense Source: external */
				/* No padding */
				/* Bitstuffing: End of carrier (802.3) */
				/* CRC: 32 bit CCITT II CRC polyn. */
				/* CRC Insertion */
				/* No Xmit on no carrier */
				/* NRZ encoding/decoding */
				/* Broadcast allowed */
				/* Normal (vs. promiscuous) mode */
				/* Unclear what bit 10 on does */
  SWAB(0x003C)			/* min pkt size to 60 (was 64) */
};

/* from send.c */
extern short dlen;
extern char outbuf[];
u_char lap_head[3];
u_char atwr_diag[1];


struct fp_atwrite atwr_proto[] = {
	3, (u_char *) lap_head,
	2, (u_char *) &dlen,
	1, (u_char *) atwr_diag,
	0, (u_char *) outbuf,
	0, (u_char *) 0
};

struct fp_proelem elem[1];
struct fp_protect prot;

data_init()
{
	/* from gw.c */
	extern struct ifnet ifie_proto, ifab_proto, ifet_proto;
	/* EtherTalk address aquisition variables */
	extern iaddr_t et_probe;
	extern short et_probe_count;

	/* from ie.c */
	extern struct cb xmit;
	extern struct cb iasetup;
	extern struct cb ieconfig;
	/* from send.c */
	extern struct fp_atwrite the_pkt[];
	register struct fp_atwrite *ap,*bp;

	/* from gw.c */
	ddpWKSUnix = defddpWKSUnix;
	ifie = ifie_proto;
	ifab = ifab_proto;
	ifet = ifet_proto;
	msclock = 0;

	et_probe = 0;
	((char *)&et_probe)[3] = 0x7f; /* start PROBE's in server range */
	et_probe_count = 0;

	/* from ie.c */
	xmit.cb_cmd = SWAB(CB_EL|CB_I|CBC_TRANS);
	iasetup.cb_cmd = SWAB(CB_EL | CBC_IASETUP);
	ieconfig = ieconf_proto;

	/* from send.c */
	lap_head[0] = (u_char) 0xFF;
	lap_head[1] = (u_char) 0x00;
	lap_head[2] = (u_char) 'K';
	atwr_diag[0] = 'D';
	ap = the_pkt;
	bp = atwr_proto;
	while (ap < &the_pkt[5]) {
		*ap++ = *bp++;
	}

}

checksum(begin,dataend)
char *begin;
char *dataend;
{
	/* set up protected ram areas */
	/* beginning of text segment through the end of initialized data */
	elem[0].fpp_memp = begin;
	elem[0].fpp_count = ((int)dataend) - ((int)begin);

	/* make the protect call */
	prot.fpt_oper = PR_PROTECT;
	prot.fpt_count = 1;
	prot.fpt_elem = elem;
	K_PROTECT(&prot);
}
