/*
 *  AppleTalk / Ethernet gateway definitions.
 *
 *  (c) 1984, Stanford Univ. SUMEX project.
 *  May be used but not sold without permission.
 *
 *  (c) 1986, Kinetics, Inc.
 *  May be used but not sold without permission.
 *
 *  $Header: gw.h,v 4.1 88/11/01 19:49:21 sw0l Locked $
 */

#include "mung_gw.h"

#ifdef noprepend
#define	end	_end
#define	begin	_begin
#define	edata	_edata
#endif

typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef unsigned short	n_short;
typedef unsigned long	n_time;

#define	ntohs(a) (a)
#define	ntohl(a) (a)
#define	htons(a) (a)
#define	htonl(a) (a)

typedef	char *	caddr_t;		/* 'core' address type */
typedef long iaddr_t;			/* internet address type */

#define	NULL	0


/*
 * Configuration structure.
 */
struct conf {
	iaddr_t	ipaddr;			/* IP address of gateway */
	iaddr_t	ipadmin;		/* addr of admin host */
	iaddr_t	iproutedef;		/* default route */
	u_char	etheraddr[6];		/* ethernet hardware address */
	u_short	ready;			/* ready flag */
#define	confPrefix	20		/* manditory config prefix length */
#define	confReady	0x1234		/* magic flag value in 'ready' field*/
	iaddr_t	ipbroad;		/* broadcast addr on ether */
	iaddr_t	ipname;			/* address of name server */
	iaddr_t	ipdebug;		/* address of debug host */
	iaddr_t	ipfile;			/* address of file server */
	u_long	ipother[4];		/* other addresses passed via IPGP */
#define ipsmask anetet		        /* old use for this field */
	u_short	anetet;		        /* ethertalk net number of enet */
#define ipsshift startddpWKSUnix	/* old: subnet shift (unused) */
	u_short	startddpWKSUnix;	/* start of unix WKS udp ports */
	u_long	flags;			/* various bit flags */
#define	conf_stayinzone 0x1		/* no looking at other zones */
#define conf_laserfilter 0x2		/* NBP filtering for LaserWriters */
#define	conf_tildefilter 0x4		/* NBP filtering, "name~" */
	u_short	ipstatic;		/* number of static IP addrs */
	u_short	ipdynamic;		/* number of dynamic IP addrs */
	u_short	atneta;			/* atalk net #, appletalk */
	u_short	atnete;			/* atalk net #, ethernet */
};

/*
 * Network interface structure.
 */
struct ifnet {
	char	if_name[8];
	short	if_unit;	/* unit is port now */
	iaddr_t	if_addr;		/* IP address */
	short	if_addrform;		/* ARP address format for IP */
	short	if_haddrlen;		/* hardware address length */
	short	if_haddrform;		/* ARP hardware addr format */
	int	(*if_output)();		/* packet output routine */
	int	(*if_matchus)();	/* match us routine */
	u_char	if_flags;	/* flags */
#define IF_APPLETYPE 0x1		/* send ALAP or ELAP out */
#define IF_ALAP 0x2		/* send outgoing as ALAP (LocalTalk) */
#define IF_IPUDP 0x4		/* send outgoing as IP/UDP */
	u_char	if_dnode;		/* ddp node # */
 	u_short	if_dnet;		/* ddp net # */
	char	if_haddr[8];		/* big enough to hold any haddr */
	iaddr_t	if_addrnet;		/* IP address, net part */
	struct	ifnet *if_next;		/* next if */
};

/*
 * Address families understood by interface output encapsulation 
 * routine (*if_output)();
 */
#define	AF_IP		0		/* address family IP */
#define	AF_DDP		1		/* .. .. DDP */
#define	AF_LINK		2		/* link level (Ethernet or AppleTalk) */
#define	AF_ARP		3		/* address resolution proto */
#define	AF_SDDP		4		/* short DDP */
#define	AF_RTMP		5		/* RTMP */
/* Private field(s) used in packet buffer header */
#define	p_if(p)	(*(struct ifnet **)&((p)->p_head[0])) /* interface ptr */
/* fast copy of ether address, assumes address on an even boundary */
#define eaddrcopy(src,dst) { \
	*((long *)dst) = *((long *)src); \
	*((short *)(((char *)dst) + 4)) = *((short *)(((char *)src) + 4));}


/*
 * AppleTalk route table.
 */
/*
 * This would be cleaner, and we could dispatch faster, if there was
 * a pointer to the interface structure with each routing entry.
 * Unfortunately we probably can't afford the 256 bytes of storage 
 * that would take.
 */
struct aroute {
	long	node;			/* atalk node number OR IP addr */
	u_short	net;			/* atalk net number, 0 if unused */
	u_char	flags;			/* flags */
	u_char	hops;			/* # hops to this net */
	u_char	zone;			/* index+1 of slot in azone */
	u_char	age;			/* age of entry in 20 second ticks */
	u_char port;			/* port route came in on */
	/* byte is used anyway for alignment */
};
/* room for 3 main ports */
#define MAX_PORT 3

#define	NAROUTE	16			/* max # table entries */
#ifdef notdef
#define ETALK_ROUTE 0x100
#define arouteIP(ar) ((ar)->node & 0xFFFFFE00) /* true if route via internet*/
#define arouteET(ar) ((ar)->node & ETALK_ROUTE)/* true if route vi Ethertalk */
#endif
#define arouteIP(ar) (porttoif[(ar)->port]->if_flags & IF_IPUDP)
#define	arouteBad(ar) (arouteIP(ar) ? ((ar)->age > 15) : ((ar)->age > 1))
/* also see flags defined in struct arouteTuple (file gwctl.h) */

#define	NAZONE	32		/* max number of zone names for now */
/* Magic ZONE name string. If a zone is given this name then it will receive */
/* all NBP requests - that is, a host on this net can be in any zone */
/* This is probably only useful for CAP nets where the zone is hardwired */
#define ALLZONES "ALL"

/*
 * IP dynamic address assignment table.
 *
 * Index into the table is the offset from conf.ipaddr + conf.ipstatic.
 */
struct ipdad {
	u_short	net;		/* appletalk net number of last user */
	u_char	node;
	u_char	flags;		/* flags */
	u_short	timer;		/* ticks since last used */
};
#define	NIPDAD		12	/* max number of table entries */
#define	ipdadTimerMax	0x7FFF
#define	ipdadTimerMin	5	/* unused for 5 minutes before reassigned */


/*
 * Statistics.
 */
struct stats {
	int	dropabin;		/* dropped ab in pkts */
	int	dropiein;
	int	droprouteip;		/* pkts dropped by routeip */
	int	droprouteddp;
};


/*
 * IP address macros.
 */
#define	ipsub(ia)	(((ia)>>ipsubshift) & ipsubmask)
#define	ipbroadcast(ia)	(((ia) & 0xFF) == 0xFF)	/* Jeff would complain */
#define	ipnetpart(ia)	(IN_CLASSA((ia)) ? ((ia) & IN_CLASSA_NET) : \
	(IN_CLASSB((ia)) ? ((ia) & IN_CLASSB_NET) : ((ia) & IN_CLASSC_NET)))
#define	iphostpart(ia)	(IN_CLASSA((ia)) ? ((ia) & IN_CLASSA_HOST) : \
	(IN_CLASSB((ia)) ? ((ia) & IN_CLASSB_HOST) : ((ia) & IN_CLASSC_HOST)))
