/*
**	Copyright (C) 1987 Kinetics, Inc.  All Rights Reserved.
**	This program contains proprietary confidential information
**	and trade secrets of Kinetics, Inc.  Reverse engineering
**	of object code is prohibited.  Use of copyright notice
**	is precautionary and does not imply publication.
**
**
**	WARNING: used for both assembly and C language source files
**
*/

/* offsets into LAP packet */
#define	LAP_DST		0
#define	LAP_SRC		1
#define	LAP_TYPE	2
#define	LAP_HEAD	3
#define	CNT_HI		3
#define	CNT_LO		4
#define	KTYPE		5
#define	SRECTYPE	6
#define	KCNUM		6
#define	KDMSG		6
#define	KBINARY		6
#define	KCNT		6
#define	KADHIW		6
#define	KPARMS		7
#define	KASCII		7
#define	KRCHI		7
#define	KADLOW		8
#define	KRCLO		8
#define	KDATA		10

/* offsets via LAP data area */
/* # of bytes of data - high order byte */
#define LAP_CNT_HI	  (CNT_HI - LAP_HEAD)
/* # of bytes of data - low order byte */
#define LAP_CNT_LO	  (CNT_LO - LAP_HEAD)
/* boot protocol type byte */
#define	PROTO_TYPE_OFF	  (KTYPE - LAP_HEAD)
/* beginning of S-record */
#define	SREC_OFF	  (SRECTYPE - 1 - LAP_HEAD)
/* command type byte */
#define	CMD_TYPE_OFF	  (KCNUM - LAP_HEAD)
/* beginning of diagnostic string */
#define	D_STR_OFF	  (KDMSG - LAP_HEAD)

/*
 *  KFPS Boot Protocol defines
 */

/* @ LAP_TYPE: KFPS boot protocol */
#define	KPROTO	0x4B

/* @ KTYPE: boot protocol packet types */
/* 'A' acknowledge S-record (KFPS transmits) */
#define	T_ACK	0x41
/* 'B' boot-me (KFPS transmits) */
#define	T_BOOT	0x42
/* 'C' command (KFPS receives) */
#define	T_CMD	0x43
/* 'D' diagnostic (KFPS transmits) */
#define	T_DIAG	0x44
/* 'R' response to a command (KFPS transmits) */
#define	T_RESP	0x52
/* 'S' Motorola S-record (KFPS receives) */
#define T_SREC	0x53

/* types of command packets and their corresponding
   structures are specified in cmdidx.h */
