/*
 *  C language version (c) 1984, Stanford Univ. SUMEX project.
 *  May be used but not sold without permission.
 *
 *  (c) 1986, Kinetics, Inc.
 *  May be used but not sold without permission.
 *
 *  $Header: ether.h,v 4.1 88/11/01 19:47:59 sw0l Exp $
 */

/*
 * Ethernet address - 6 octets
 */
struct ether_addr {
	u_char	ether_addr_octet[6];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct	ether_header {
	struct	ether_addr ether_dhost;
	struct	ether_addr ether_shost;
	u_short	ether_type;
};

#define	ETHERTYPE_PUPTYPE	0x0200		/* PUP protocol */
#define	ETHERTYPE_IPTYPE	0x0800		/* IP protocol */
#define ETHERTYPE_ARPTYPE	0x0806		/* Addr. resolution protocol*/
#define ETHERTYPE_ETHERTALK     0x809b          /* Apple Ethertalk encap. */
#define ETHERTYPE_AARPTYPE      0x80F3          /* Apple Addr. res. protocol */

#define	ETHERMTU	1500
#define	ETHERMIN	(60-14)
