/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#if defined(AIX31) || defined(AIX32)
#define THIS_IS_SUPPORTED
#include <sys/statfs.h>
#endif

#ifdef THIS_IS_SUPPORTED

#include <sys/vfs.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "xdr_lib.h"
#include "debug.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

#define xdr_fsid_t(xdrs, fsidp) \
			( xdr_long(xdrs, &((fsidp)[0])) && \
			  xdr_long(xdrs, &((fsidp)[1])) )

xdr_statfs(xdrs, statfsp)
register XDR *xdrs;
register struct statfs *statfsp;
{
	char	*fname = &statfsp->f_fname[0];
	char	*fpack = &statfsp->f_fpack[0];

	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_version));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_type));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_bsize));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_blocks));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_bfree));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_bavail));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_files));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_ffree));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_fsid.val[0]));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_fsid.val[1]));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_vfstype));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_nlsdirtype));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_vfsnumber));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_vfsoff));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_vfslen));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_vfsvers));
	XDR_ASSERT(xdr_string(xdrs, &fname,32));
	XDR_ASSERT(xdr_string(xdrs, &fpack,32));
	XDR_ASSERT(xdr_long(xdrs, &statfsp->f_name_max));

	return( TRUE );
}

#else THIS_IS_SUPPORTED
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "xdr_lib.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT


xdr_statfs(xdrs, statfsp)
register XDR *xdrs;
register *statfsp;
{
#ifdef LINT
	printf( "THIS IS BULL", xdrs, statfsp );
#endif LINT
	return( FALSE );
}
#endif THIS_IS_SUPPORTED
