/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include "condor_sys.h"
#include "errno.h"
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#if defined(ULTRIX) || defined(ULTRIX42)
#include <sys/mount.h>
#else defined(ULTRIX) || defined(ULTRIX42)

#ifdef IRIX405
#include <sys/statfs.h>
#else
#include <sys/vfs.h>
#endif

#endif defined(ULTRIX) || defined(ULTRIX42)

extern int	Syscalls;

#if defined(IRIX405)
statfs( path, buf, len, fstyp )
char	*path;
struct fs_data *buf;
int		len;
int		fstyp;
#else
statfs( path, buf )
char	*path;
struct fs_data *buf;
#endif
{
	int rval;
	extern int	errno;

#if defined(IRIX405)
	if( Syscalls & SYS_LOCAL ) {
		rval = STATFS( path, buf, len, fstyp );
	} else {
		errno = ESYSNOTSUPP;
		rval =  -1;
	}
#else
	if( Syscalls & SYS_LOCAL ) {
		rval = STATFS( path, buf );
	} else {
		errno = ESYSNOTSUPP;
		rval =  -1;
	}
#endif
}
