/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#if defined(IRIX405)
#define __EXTENSIONS__
#include <malloc.h>
#endif


#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>

#include "condor_sys.h"
#include "ckpt_file.h"
#include "trace.h"
#include "except.h"
#include "fileno.h"
#include "debug.h"

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

char		CkptName[ MAXPATHLEN ];
extern RESTREC	RestartInfo;
extern int		RunningAsCondor;

/* static int HasRun = 0; */
int HasRun = 0;

#ifdef VOID_SIGNAL_RETURN
#define sighandler_t void
#else
#define sighandler_t int
#endif


/*
**	Checkpoint Main routine
*/
MAIN( argc, argv, envp )
int	 argc;
char **argv;
char **envp;
{
	sighandler_t		CKPT();
	struct sigvec		action;
	register int i;
	extern int (*_EXCEPT_Cleanup)(), abort();
	int		wait_for_debugger = 1;


#ifdef DEBUGGER
	/*
	mallopt( M_DEBUG, 0 );
	*/
	while( wait_for_debugger )
		;
#endif DEBUGGER

#ifdef CONDOR
	RunningAsCondor = 1;
#endif CONDOR

	if( HasRun ) {
		restart( CkptName );
	}
	HasRun = 1;

	/*
	**	Initialize table of open files
	*/
	for( i = 0; i < NOFILE; i++ ) {
		RestartInfo.rr_file[i].fi_flags = 0;	/* Not open */
		RestartInfo.rr_file[i].fi_fdno = -1;	/* Map to invalid fd */
	}
	if( RunningAsCondor ) {
		InitStaticFile( RSC_SOCK, FI_WELL_KNOWN );
		InitStaticFile( CLIENT_LOG, FI_WELL_KNOWN );
	} else {
		InitStaticFile( 0, FI_PREOPEN | FI_NFS );
		InitStaticFile( 1, FI_PREOPEN | FI_NFS );
		InitStaticFile( 2, FI_PREOPEN | FI_NFS );
	}
	/*
	DumpOpenFds();
	*/

	/*
	exit( 0 );
	*/

	/*
	**	Initial system calls should be local and unrecorded
	*/
	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	action.sv_handler = CKPT;
	action.sv_mask = 0;
#ifdef DYNIX
	action.sv_onstack = 0;
#else DYNIX
	action.sv_flags = 0;
#endif DYNIX

	if( sigvec(SIGTSTP,&action,NULL) < 0 ) {
		EXCEPT( "can't set sigaction for TSTP" );
	}

	/*
	**	Unblock any blocked signals (SIGTSTP in particular)
	*/
	sigsetmask(0);

	/*
	**	Further system calls will be remote and recorded...
	*/
	if( RunningAsCondor ) {
		RSC_Init( RSC_SOCK, CLIENT_LOG );
		dprintf_init( CLIENT_LOG );
		DebugFlags |= D_NOHEADER;
		(void) SetSyscalls( SYS_REMOTE | SYS_RECORDED );
	} else {
		(void) SetSyscalls( SYS_LOCAL | SYS_RECORDED );
	}
	/*
	DebugFlags |= D_SYSCALLS;
	*/

#ifdef DEBUG
	DebugFlags = -1;
#endif DEBUG

	(void) strcpy( CkptName, *argv );

	/*
	**	chdir has the side effect of setting the variable Condor_CWD
	*/

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	if( chdir(".") < 0 ) {
		EXCEPT("Initialize Condor_CWD");
	}

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/


	/*
	exit( 0 );
	*/

	if( RunningAsCondor ) {
		open_std_files( argv[1], argv[2], argv[3] );
		argv += 3;
		argc -= 3;
	} /* else {
		PreOpen( fileno(stdin) );
		PreOpen( fileno(stdout) );
		PreOpen( fileno(stderr) );
	} */

	/*
	exit( 0 );
	*/

	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	_EXCEPT_Cleanup = abort;

	/*
	DumpOpenFds();
	fflush( stdout );
	*/

	/*
	exit( 0 );
	*/

	return( main(argc, argv, envp) );
}

extern int Method;
open_std_files( in, out, err )
char	*in;
char	*out;
char	*err;
{
	int		fd;

	dprintf( D_ALWAYS, "Entering open_std_files()\n" );


	std_open( in, O_RDONLY, 0 );
	std_open( out, O_WRONLY, 1 );
	std_open( err, O_WRONLY, 2 );

	dprintf( D_ALWAYS, "Opened \"%s\", \"%s\", and \"%s\"\n",
					in, out, err );

}

std_open( name, flags, fd_no )
char	*name;
int		flags;
int		fd_no;
{
	int		fd;

	if( (fd=open(name,flags,0)) < 0 ) {
		dprintf( D_ALWAYS, "Can't open \"%s\"\n", name );
		EXCEPT( "open(%s,0%o,0)", name, flags );
	}

	if( fd != fd_no ) {
		dup2( fd, fd_no );
		close( fd );
		/*
		dprintf( D_ALWAYS, "Dup'd %d to %d\n", fd, fd_no );
		*/
	}
}

InitStaticFile( fd, flag )
int		fd;
int		flag;
{
	RestartInfo.rr_file[ fd ].fi_fdno = fd;
	RestartInfo.rr_file[ fd ].fi_flags = (FI_OPEN | flag);
}
