/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include "condor_sys.h"
#include "debug.h"
#include "ckpt_file.h"

extern int	Syscalls;
extern char	Condor_CWD[];


char	*internal_name(), *translate(), *gen_name(), *rindex();
char	*LocalName;
int		Method;
int		AvoidNFS = 0;

#if 0
_open( path, flags, mode )
char *path;
int flags, mode;
{
	return open(path,flags,mode);
}
#endif

open( path, flags, mode )
char *path;
int flags, mode;
{
	int rval;

/*
	dprintf( D_ALWAYS, "Before open\n" );
	DumpOpenFds();
	display_syscall_mode( __LINE__, __FILE__ );
*/

	if( (Syscalls & SYS_LOCAL) == SYS_LOCAL ) {
		rval = syscall( SYS_open, path, flags, mode );
		Method = FI_NFS;
		LocalName = NULL;
	} else {
		if( (rval = nfs_open(path,flags,mode)) >= 0 ) {
			Method = FI_NFS;
		} else {
			rval = REMOTE_syscall( CONDOR_open, path, flags, mode );
			Method = FI_RSC;
		}
	}


	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			rval = MarkFileOpen( rval, path, flags, Method );
		}
	}

/*
	debug_open( path, rval );
	display_syscall_mode( __LINE__, __FILE__ );
	dprintf( D_ALWAYS, "After open(\"%s\",%d,%d) returns %d\n",
										path, flags, mode, rval );
	DumpOpenFds();
*/

	return( rval );
}
