/*     Do not remove the following line! Required for SCCS.  */
         static char sccsid[] = "@(#)setnoso.c	5.1 5/1/92"; 					
/* Turn off the shared object flags */

#include <unistd.h>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/errno.h>
#include <fcntl.h>
#include <filehdr.h>

main(int argc, char *argv[])
{
  struct filehdr buffer;
  int i, fd;

  if (argc != 2) {
    fprintf(stderr, "Useage: %s filename.o\n", argv[0]);
    exit(22);
  }

  if ((fd = open(argv[1], O_RDWR, 0)) == -1) {
    perror("error opening device file");
    exit(23);
  }

  if ((i = read(fd, (char *)&buffer, (int)sizeof(struct filehdr))) == -1) {
    fprintf(stderr, "Error %d reading %s", errno, argv[1]);
    exit(24);
  }

  buffer.f_flags &= ~F_EXEC;
  buffer.f_flags &= ~F_DYNLOAD;
  buffer.f_flags &= ~F_SHROBJ;

  if (lseek(fd, 0, SEEK_SET) == -1) {
    fprintf(stderr, "Error %d seek in %s", errno, argv[1]);
    exit(25);
  }

  if ((i = write(fd, (char *)&buffer, (int)sizeof(struct filehdr))) == -1) {
    fprintf(stderr, "Error %d writing %s", errno, argv[1]);
    exit(26);
  }

  return 0;
}
