/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <sys/types.h>
#include <sys/user.h>
#include <core.h>
#include <filehdr.h>
#include <aouthdr.h>
#include <scnhdr.h>
#include <loader.h>
#include <reloc.h>
#include <linenum.h>
#include <sys/ldr.h>
#include "debug.h"

#define PRINT_DECIMAL(item) dprintf(D_ALWAYS,"	item = %d\n",ptr->item)
#define PRINT_HEX(item) dprintf(D_ALWAYS,"	item = 0x%x\n",ptr->item)
#define PRINT_OCTAL(item) dprintf(D_ALWAYS,"	item = 0%o\n",ptr->item)
#define PRINT_STRING(item) dprintf(D_ALWAYS,"	item = %s\n",ptr->item)
#define PRINT_BOOL(item) dprintf(D_ALWAYS,"	item is %s\n",ptr->item?"TRUE":"FALSE")
#define PRINT_DATE(item) dprintf(D_ALWAYS,"	item is %s", ctime(&(ptr->item)) )


	/* Generate a pointer into memory given another pointer and an offset */
#define MSEEK(ptr,off) ((char *)(ptr)+(int)(off))

	/* Loader relocation entry types */
#define TEXT_SYMBOL 0
#define DATA_SYMBOL 1
#define BSS_SYMBOL 2

/*
** Display a list of ld_info structures.  Each structure contains the
** bytes offset to the next structure in ldinfo_next.
*/
display_ld_info_list( ptr, label )
struct ld_info	*ptr;
char			*label;
{
	for(;;) {
		display_ld_info( ptr, label );
		if( ptr->ldinfo_next ) {
			ptr = (struct ld_info *)MSEEK(ptr,ptr->ldinfo_next);
		} else {
			break;
		}
	}
}

/*
** Display a ld_info structure.  This structure specifies how an
** executable file has been loaded into memory.  Normal programs
** will have one for the a.out, and one for libc.
*/
display_ld_info( ptr, label )
struct ld_info	*ptr;
char			*label;
{
	dprintf( D_ALWAYS, "%s: \n", label );
	PRINT_HEX( ldinfo_next );
	PRINT_HEX( ldinfo_textorg );
	PRINT_HEX( ldinfo_textsize );
	PRINT_HEX( ldinfo_dataorg );
	PRINT_HEX( ldinfo_datasize );
	PRINT_STRING( ldinfo_filename );
}



/*
** Display a coff section header
*/
display_scn_hdr( hdr )
struct scnhdr	*hdr;
{
	dprintf( D_ALWAYS, " %-8s ", hdr->s_name );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_paddr );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_vaddr );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_size );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_scnptr );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_relptr );
	dprintf( D_ALWAYS, "0x%-8x ", hdr->s_lnnoptr );
	dprintf( D_ALWAYS, "%-5d ", hdr->s_nreloc );
	dprintf( D_ALWAYS, "\n" );
}

/*
** Display a core file header.
*/
display_core_hdr( ptr, label )
struct core_dump	*ptr;
char				*label;
{
	dprintf( D_ALWAYS, "%s: \n", label );
	PRINT_DECIMAL( c_signo );
	PRINT_BOOL( c_flag&FULL_CORE );
	PRINT_BOOL( c_flag&UBLOCK_VALID );
	PRINT_BOOL( c_flag&USTACK_VALID );
	PRINT_BOOL( c_flag&LE_VALID );
	PRINT_BOOL( c_flag&CORE_TRUNC );
	PRINT_DECIMAL( c_entries );
	PRINT_HEX( c_tab );
	PRINT_HEX( c_stack );
	PRINT_DECIMAL( c_size );
}



/*
** Display the a.out header portion (optional header) of a coff file.
*/
display_aout_hdr( ptr, label )
struct aouthdr	*ptr;
char			*label;
{
	dprintf( D_ALWAYS, "%s: \n", label );
	PRINT_HEX( magic );
	PRINT_DECIMAL( vstamp );
	PRINT_DECIMAL( tsize );
	PRINT_DECIMAL( dsize );
	PRINT_DECIMAL( bsize );
	PRINT_HEX( entry );
	PRINT_HEX( text_start );
	PRINT_HEX( data_start );
	PRINT_HEX( o_toc );
	PRINT_DECIMAL( o_snentry );
	PRINT_DECIMAL( o_sntext );
	PRINT_DECIMAL( o_sndata );
	PRINT_DECIMAL( o_sntoc );
	PRINT_DECIMAL( o_snloader );
	PRINT_DECIMAL( o_snbss );
}

/*
** Display the main coff file header.
*/
display_coff_hdr( ptr, label )
struct filehdr	*ptr;
char			*label;
{
	dprintf( D_ALWAYS, "%s: \n", label );
	PRINT_OCTAL( f_magic );
	PRINT_DECIMAL( f_nscns );
	PRINT_DATE( f_timdat );
	PRINT_HEX( f_symptr );
	PRINT_DECIMAL( f_nsyms );
	PRINT_DECIMAL( f_opthdr );
	PRINT_HEX( f_flags );
}


/*
** Display all the section headers in a coff file.
*/
display_scn_hdrs( ptr, label, n_sections )
struct scnhdr	*ptr;
char			*label;
int				n_sections;
{
	int		i;

	dprintf( D_ALWAYS, "%s:\n", label );
	dprintf( D_ALWAYS, " %-8s %-10s %-10s %-8s %-10s %-10s %-10s %-5s\n",
	"name", "paddr", "vaddr",  "size", "scnptr", "relptr", "lnnoptr", "nreloc" );
	for( i=0; i<n_sections; i++ ) {
		display_scn_hdr( ptr + i );
	}
}

/*
** Display the loader's symbol table, given a pointer to the loader section
** header.
*/
display_ldsym_tab( hdr )
struct ldhdr	*hdr;
{
	int		i;
	struct ldsym	*tab;
	char			*str_tab;

	tab = (struct ldsym *)MSEEK( hdr, sizeof(struct ldhdr) );
	str_tab = MSEEK( hdr, hdr->l_stoff );

	dprintf( D_ALWAYS, "Loader Symbol Table:\n" );
	dprintf( D_ALWAYS, "%-8s %-10s %-10s\n", "index", "name", "value" );

	for( i=0; i<hdr->l_nsyms; i++ ) {
		display_loader_symbol( i, hdr );
	}
}

/*
** Display a loader symbol.
*/
display_loader_symbol( n, hdr )
int				n;
struct ldhdr	*hdr;
{
	char			*str_tab;
	struct ldsym	*sym_tab, *sym;
	int				idx = n - 3;

	sym_tab = (struct ldsym *)MSEEK( hdr, sizeof(struct ldhdr) );
	str_tab = MSEEK( hdr, hdr->l_stoff );
	sym 	= sym_tab + idx;

	dprintf( D_ALWAYS, "%-8d ", n );
	switch( n ) {
		case TEXT_SYMBOL:
			dprintf( D_ALWAYS, "%-10s ", "(text)" );
			break;
		case BSS_SYMBOL:
			dprintf( D_ALWAYS, "%-10s ", "(bss)" );
			break;
		case DATA_SYMBOL:
			dprintf( D_ALWAYS, "%-10s ", "(data)" );
			break;
		default:
		if( sym->l_zeroes ) {
			dprintf( D_ALWAYS, "%-10s ", sym->l_name );
		} else {
			dprintf( D_ALWAYS, "%-10s ", MSEEK(str_tab, sym->l_offset) );
		}
	}
	dprintf( D_ALWAYS, "0x%-8x\n", sym->l_value );
}

/*
** Display a symbol table entry.
*/
display_syment( sym, idx )
struct syment	*sym;
int				idx;
{
	dprintf( D_ALWAYS, "[%d] syment value=0x%x, scnum=%d, numaux=%d\n",
		idx, sym->n_value, sym->n_scnum, sym->n_numaux );
}

/*
**
*/
display_reloc_labels()
{
	dprintf( D_ALWAYS, "%-8s %-10s %-8s %-8s %-8s ", "rel_idx", "vaddr", "type",
	"r_type", "section" );
	dprintf( D_ALWAYS, "%-8s %-10s %-10s\n", "sym_idx", "name", "value" );
}

/*
** Display a loader relocation entry.
*/
display_reloc( n, hdr, text_sect, bss_sect, data_sect )
int				n;
struct ldhdr	*hdr;
int				text_sect;
int				bss_sect;
int				data_sect;
{
	struct ldsym	*sym_ptr;
	struct ldrel	*rel_tab, *ptr;
	struct ldsym	*sym_tab;
	char			*str_tab;

	sym_tab = (struct ldsym *)MSEEK( hdr, sizeof(struct ldhdr) );
	rel_tab = (struct ldrel *)MSEEK(sym_tab, LDSYMSZ * hdr->l_nsyms );
	str_tab = MSEEK( hdr, hdr->l_stoff );
	ptr = &rel_tab[n];

	dprintf( D_ALWAYS, "%-8d ", n );
	dprintf( D_ALWAYS, "0x%-8x ", ptr->l_vaddr );

	switch( ptr->l_symndx ) {
		case TEXT_SYMBOL:
			dprintf( D_ALWAYS, "%-8s ", "TEXT" );
			break;
		case BSS_SYMBOL:
			dprintf( D_ALWAYS, "%-8s ", "BSS" );
			break;
		case DATA_SYMBOL:
			dprintf( D_ALWAYS, "%-8s ", "DATA" );
			break;
		default:
			dprintf( D_ALWAYS, "%-8d ", ptr->l_symndx );
	}

	dprintf( D_ALWAYS, "%-8d ", ptr->l_rtype );

	if( ptr->l_rsecnm == text_sect ) {
		dprintf( D_ALWAYS, "%-8s ", "TEXT" );
	} else if( ptr->l_rsecnm == bss_sect ) {
		dprintf( D_ALWAYS, "%-8s ", "BSS" );
	} else if( ptr->l_rsecnm == data_sect ) {
		dprintf( D_ALWAYS, "%-8s ", "DATA" );
	} else {
		dprintf( D_ALWAYS, "%-8d ", ptr->l_rsecnm );
	}

	sym_ptr = sym_tab + (ptr->l_symndx - 3);
	display_loader_symbol( ptr->l_symndx, hdr );

}

flock(){}
