/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#if defined(AIX31) || defined(AIX32)
#include <stdio.h>
#include <nlist.h>
#include <sys/sysinfo.h>
#include <sys/file.h>
#include "debug.h"

#define INFO_SIZE sizeof(struct sysinfo)

extern struct nlist	nl[];		/* the kernel's name list */
#define X_SYSINFO 2				/* location of sysinfo entry in name list */
extern int	Kmem;				/* file descriptor into /dev/kmem */

#define AVG_INTERVAL 60			/* Calculate a one minute load average */

int		PrevInRunQ, PrevTicks, CurInRunQ, CurTicks;
time_t	LastPoll;
off_t	KernelAddr;

float
aix31_load_avg()
{
	float	short_avg;
	static float	long_avg;
	static time_t	now, elapsed_time;
	static int		n_polls = 0;
	float	weighted_long, weighted_short;

	poll( &CurInRunQ, &CurTicks, &now );

	if( n_polls == 0 ) {	/* first time through, just set things up */
		PrevInRunQ = CurInRunQ;
		PrevTicks = CurTicks;
		LastPoll = now;
		n_polls = 1;
		short_avg = 1.0;
		long_avg = 1.0;
		dprintf( D_LOAD, "First Time, returning 1.0\n" );
		return 1.0;
	}
		
	if( CurTicks == PrevTicks ) {
		dprintf( D_LOAD, "Too short of time to compute avg, returning %5.2f\n",
																	long_avg );
		return long_avg;
	}
	short_avg = (float)(CurInRunQ - PrevInRunQ) / (float)(CurTicks - PrevTicks)
																	- 1.0;
	elapsed_time = now - LastPoll;

	if( n_polls == 1 ) {	/* second time through, init long average */
		long_avg = short_avg;
		PrevInRunQ = CurInRunQ;
		PrevTicks = CurTicks;
		LastPoll = now;
		n_polls = 2;
		dprintf( D_LOAD, "Second time, returning %5.2f\n", long_avg );
		return long_avg;
	}

		/* after second time through, update long average with new info */

	weighted_short = short_avg * (float)elapsed_time / (float)AVG_INTERVAL;
	weighted_long = long_avg *
				(float)(AVG_INTERVAL - elapsed_time) / (float)AVG_INTERVAL;
	long_avg = weighted_long + weighted_short;
	dprintf( D_LOAD, "ShortAvg = %5.2f LongAvg = %5.2f\n",
														short_avg, long_avg );
	dprintf( D_LOAD, "\n" );
	PrevInRunQ = CurInRunQ;
	PrevTicks = CurTicks;
	LastPoll = now;

	return long_avg;
}



poll( queue, ticks, poll_time )
int		*queue;
int		*ticks;
int		*poll_time;
{
	struct sysinfo	 info;

	if( lseek(Kmem,nl[X_SYSINFO].n_value,L_SET) < 0 ) {
		perror( "lseek" );
		exit( 1 );
	}

	if( read(Kmem,(char *)&info,INFO_SIZE) < INFO_SIZE ) {
		perror( "read from kmem" );
		exit( 1 );
	}

	*queue = info.runque;
	*ticks = info.runocc;

	(void)time( poll_time );
}
#endif /* AIX */
