/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include "debug.h"
#include "condor_sys.h"


/* ARGSUSED */
main( argc, argv, envp )
int argc;
char **argv, **envp;
{
	char ckptfile[ 1024 ];
	int		scm;
#if defined(MALLOC_DEBUG)
	int	malloc_debug = 1;
#else
	int	malloc_debug = 0;
#endif

#if defined(MALLOC_DEBUG)
	if( malloc_debug) {
		clearalloc( "/tmp/mkckpt", 1 );
	}
#endif

	/*
	** Things are a bit strange here since we are linked with the
	** condor syscall library which is intended to be used for
	** checkpointing, with remote system calls as an optional
	** feature.  First we turn off all file descriptor mapping, and
	** close 0 as we won't need it.  Then we turn on mapping and
	** mark 1 and 2 as pre-existing files we were born with.
	*/
	SetSyscalls( SYS_LOCAL | SYS_UNRECORDED );
	(void)close( 0 );
	SetSyscalls( SYS_LOCAL | SYS_RECORDED );
	PreOpen( 1 );
	PreOpen( 2 );

	if( argc < 2 ) {
		fprintf(stderr, "Usage: %s ObjectFile [CoreFile]\n", *argv);
		exit( 1 );
	}

	if( argc > 3 ) {
		DebugFlags |= D_CKPT;
	}

	if( argc == 2 ) {
		(void)sprintf( ckptfile, "%s.ckpt", argv[1] );

		_mkckpt( ckptfile, argv[1] );
	} else {
		(void)sprintf( ckptfile, "%s.tmp", argv[1] );
		_updateckpt( ckptfile, argv[1], argv[2] );

		(void)unlink( argv[1] );
		(void)rename( ckptfile, argv[1] );
		/*
		(void)unlink( argv[2] );
		*/
	}

	exit( 0 );
}
