/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/stat.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include "trace.h"
#include "except.h"
#include "xdr_lib.h"

#ifndef LINT
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */
#endif LINT

xdr_stat(xdrs, statp)
register XDR *xdrs;
register struct stat *statp;
{
	XDR_ASSERT(xdr_dev_t(xdrs, &statp->st_dev));
	XDR_ASSERT(xdr_ino_t(xdrs, &statp->st_ino));
	XDR_ASSERT(xdr_u_short(xdrs, &statp->st_mode));
	XDR_ASSERT(xdr_short(xdrs, &statp->st_nlink));
	XDR_ASSERT(xdr_u_short(xdrs, &statp->st_uid));
	XDR_ASSERT(xdr_u_short(xdrs, &statp->st_gid));
	XDR_ASSERT(xdr_dev_t(xdrs, &statp->st_rdev));
	XDR_ASSERT(xdr_off_t(xdrs, &statp->st_size));
	XDR_ASSERT(xdr_time_t(xdrs, &statp->st_atime));

#if !defined(IRIX405)
	XDR_ASSERT(xdr_int(xdrs, &statp->st_spare1));
#endif

	XDR_ASSERT(xdr_time_t(xdrs, &statp->st_mtime));

#if !defined(IRIX405)
	XDR_ASSERT(xdr_int(xdrs, &statp->st_spare2));
#endif

	XDR_ASSERT(xdr_time_t(xdrs, &statp->st_ctime));

#if !defined(IRIX405)
	XDR_ASSERT(xdr_int(xdrs, &statp->st_spare3));
	XDR_ASSERT(xdr_long(xdrs, &statp->st_blksize));
	XDR_ASSERT(xdr_long(xdrs, &statp->st_blocks));
#endif

#if defined(ULTRIX) || defined(ULTRIX42)
	XDR_ASSERT(xdr_u_long(xdrs, &statp->st_gennum));
	XDR_ASSERT(xdr_long(xdrs, &statp->st_spare4));
#endif

#if !defined(ULTRIX) && !defined(ULTRIX42) && !defined(IRIX405)
	XDR_ASSERT(xdr_long(xdrs, &statp->st_spare4[0]));
	XDR_ASSERT(xdr_long(xdrs, &statp->st_spare4[1]));
#endif

	return( TRUE );
}
