/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

#include <stdio.h>
#include <sys/file.h>
#include "debug.h"


main( argc, argv )
int		argc;
char	*argv[];
{
	int		bufsize, fd;
	char	*buf;
	int		nbytes;
	long	start, end;
	int		i;

	if( argc != 3 ) {
		fprintf( stderr, "Usage: %s file bufsize\n", argv[0] );
		exit( 1 );
	}

	if( (fd=open(argv[1],O_RDONLY,0)) < 0 ) {
		printf( stderr, "Open failed, errno = %d\n", errno );
		exit( 1 );
	}

	bufsize = atoi( argv[2] );
	if( bufsize <= 0 ) {
		fprintf( stderr, "Bufsize must be > 0\n" );
		exit( 1 );
	}

	if( (buf=malloc( (unsigned)bufsize )) == NULL ) {
		fprintf( stderr, "malloc failed, errno = %d\n", errno );
		exit( 1 );
	}

	for( i=0; i<2; i++) {
		(void)time( &start );
		nbytes = read_file( fd, buf, bufsize );
		(void)time( &end );
		printf( "Read %d bytes in %d seconds\n", nbytes, end - start );
		if( end - start == 0 ) {
			printf( "Avoided divide by zero\n" );
		} else {
			printf( "%dK bytes/sec\n", (nbytes / (end - start)) / 1000 );
		}
		fflush( stdout );
		ckpt();
		if( lseek(fd,0,L_SET) < 0 ) {
			perror( "lseek" );
			exit( 1 );
		}
	}
	exit( 0 );
}

read_file( fd, buf, bufsize )
int		fd;
char	*buf;
int		bufsize;
{
	int		nbytes;
	int		answer = 0;

	for(;;) {
		nbytes = read( fd, buf, bufsize );
		if( nbytes < 0 ) {
			perror( "read" );
			exit( 1 );
		}
		if( nbytes == 0 ) {
			return answer;
		}
		answer += nbytes;
	}
}
