/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include "condor_sys.h"
#include "ckpt_file.h"
#include "debug.h"

extern int	Syscalls;
extern RESTREC	RestartInfo;

#if defined(IRIX405)
_close( user_fd )
int user_fd;
{
	return close( user_fd );
}
#endif

close( user_fd )
int user_fd;
{
	int rval, fd;
	int	is_dupd = 0;
	register FINFO *fi = &RestartInfo.rr_file[ user_fd ];

	/*
	dprintf( D_ALWAYS, "Before close\n" );
	DumpOpenFds();
	*/

	fd = map_fd( user_fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( (fi->fi_flags & FI_WELL_KNOWN) == FI_WELL_KNOWN ) {
			errno = EBADF;
			return -1;
		}
		is_dupd = file_is_dupd( user_fd );
	}

	if( is_dupd ) {	/* don't close it if it's a dup */
		rval = 0;
	} else {
		if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
			rval = syscall( SYS_close, fd );
			SET_ERRNO;
		} else {
			rval = REMOTE_syscall( CONDOR_close, fd );
		}
	}

	if( (Syscalls & SYS_RECORDED) == SYS_RECORDED ) {
		if( rval >= 0 ) {
			/*
			MarkFileClosed( fd );
			*/
			MarkFileClosed( user_fd );
		}
	}

	/*
	if( rval < 0 ) {
		dprintf( D_ALWAYS, "Close(%d->%d) -- failed\n", user_fd, fd );
	} else {
		dprintf( D_ALWAYS, "Close(%d->%d) -- OK\n", user_fd, fd );
	}

	display_syscall_mode( __LINE__, __FILE__ );
	dprintf( D_ALWAYS, "After close(%d) returns %d\n", user_fd, rval );
	DumpOpenFds();
	*/

	return( rval );
}
