/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifdef NOTDEF
#include <sys/seg.h>
#endif

#include <netinet/in.h>


#include "condor_setjmp.h"
#include "condor_sys.h"
#include "trace.h"
#include "ckpt.h"
#include "except.h"
#include "debug.h"

#ifdef VOID_SIGNAL_RETURN
#define sighandler_t void
#else
#define sighandler_t int
#endif

static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

#define AOUT_HDR_SIZE   sizeof(struct aouthdr)
#define COFF_HDR_SIZE   sizeof(struct filehdr)

	/* Generate a pointer into memory given another pointer and an offset */
#define MSEEK(ptr,off) ((char *)(ptr)+(int)(off))


#define DEBUG

#define STACKSIZ	(128*1024)
char	 TmpStack[ STACKSIZ ];

extern char	Condor_CWD[ ];
char	CkptName[ MAXPATHLEN ];
extern int	RunningAsCondor;
extern int	Syscalls;

extern RESTREC	 RestartInfo;

sighandler_t CKPT();
sighandler_t KILL();

int CkptInProgress;
int SyscallInProgress;
int CkptWanted;
int KillWanted;

int	StackSize;
int		SavedBrk;
condor_jmp_buf LongJumpBuf;

/*
** Some FORTRAN compilers expect "_" after the symbol name.
*/
ckpt_() {
	ckpt();
}

/*
** And some other FORTRAN compilers expect "_" both before and after the
** symbol name.  -- ARGH!
*/
_ckpt_() {
	ckpt();
}

ckpt()
{
	int scm = SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );
	int pid = getpid();
	int	omask;

	dprintf(D_CKPT,
		"CKPT: CkptWanted %d, CkptInProgress %d, SyscallInProgress %d\n",
			CkptWanted, CkptInProgress, SyscallInProgress);

	omask = sigsetmask( 0 );
	dprintf( D_CKPT, "ckpt: old signal mask was 0%o\n", omask );
	dprintf(D_CKPT, "ckpt: about to kill(%d, SIGTSTP)\n", pid);

	kill( pid, SIGTSTP );

	(void) SetSyscalls( scm, __LINE__, __FILE__ );
}



/* Want program to die with signal 9, but this may hang the remote system
** call mechansim if it comes during a syscall.  If that's the case, just
** set a flag and do it later.  */
sighandler_t
KILL()
{

	extern int CurrentSysCall;


	dprintf(D_CKPT,
		"KILL: KillWanted %d, CkptInProgress %d, SyscallInProgress %d\n",
			KillWanted, CkptInProgress, SyscallInProgress);

	if( CkptInProgress || SyscallInProgress ) {
		if( SyscallInProgress ) {
			dprintf(D_ALWAYS, "KILL: [%s] in progress, Kill wanted\n",
					CONDOR_SYSCALLNAME(CurrentSysCall));
		}
		KillWanted = 1;
	} else {
		do_kill();
	}
}

/* Send signal 9 to self. */
do_kill()
{
	int scm = SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );
	int pid = getpid();

	dprintf(D_CKPT,
		"do_kill(): KillWanted %d, CkptInProgress %d, SyscallInProgress %d\n",
			KillWanted, CkptInProgress, SyscallInProgress);

	dprintf(D_CKPT, "do_kill: about to kill(%d, SIGKILL)\n", pid);

	kill( pid, SIGKILL );
}

sighandler_t
CKPT()
{

	extern int CurrentSysCall;


	dprintf(D_CKPT,
		"CKPT: CkptWanted %d, CkptInProgress %d, SyscallInProgress %d\n",
			CkptWanted, CkptInProgress, SyscallInProgress);

	if( CkptInProgress || SyscallInProgress ) {
		if( SyscallInProgress ) {
			dprintf(D_ALWAYS, "CKPT: [%s] in progress, checkpoint wanted\n",
					CONDOR_SYSCALLNAME(CurrentSysCall));
		}
		CkptWanted = 1;
		return;
	}

	do_CKPT(	0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
				0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0
	);
}

static int	CkptSCM;

/* Note: on some architectures, certain registers aren't saved by the signal
** handling mechanism.  Instead they are saved on the stack frame by 
** any routine which wants to use them.  Here we force that to happen,
** since otherwise they would be lost after a checkpoint.  We have to play
** some games to keep the optimizers from out smarting us -- GROT.
*/
float	fool_compiler;
do_CKPT(		f1, f2, f3, f4, f5, f6, f7, f8,
				f9, f10, f11, f12, f13, f14, f15, f16,
				i1, i2, i3, i4, i5, i6, i7, i8,
				i9, i10, i11, i12, i13, i14, i15, i16 )
register float	f1, f2, f3, f4, f5, f6, f7, f8,
				f9, f10, f11, f12, f13, f14, f15, f16;
register int	i1, i2, i3, i4, i5, i6, i7, i8,
				i9, i10, i11, i12, i13, i14, i15, i16;
{
	int rval;
	fool_compiler =	i1 + i2 + i3 + i4 + i5 + i6 + i7 + i8 +
					i9 + i10 + i11 + i12 + i13 + i14 + i15 + i16 +
					f1 + f2 + f3 + f4 + f5 + f6 + f7 + f8 +
					f9 + f10 + f11 + f12 + f13 + f14 + f15 + f16;

	CkptInProgress = 1;
	CkptWanted = 0;
	KillWanted = 0;

	/*
	**	Save the current offset of all open files.
	*/
	SetFileInfo();

	CkptSCM = SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );

	dprintf(D_CKPT, "do_CKPT: CkptSCM = 0x%x\n", CkptSCM);
	dprintf( D_CKPT, "About to condor_setjmp(0x%x)\n", LongJumpBuf );
	rval = condor_setjmp(LongJumpBuf);

	if( rval != 0 ) {
		dprintf(D_CKPT, "do_CKPT: setjmp returned %d, CkptSCM 0x%x\n",
				rval, CkptSCM);
		(void) SetSyscalls( CkptSCM, __LINE__, __FILE__ );
		return;
	} else {
		dprintf(D_CKPT,"do_CKPT: setjmp returned zero, CkptSCM 0x%x\n",
				CkptSCM);
		dump_core();
	}
}

dump_core()
{

	(void) SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );

	/* Set up SIGQUIT to produce a full core dump. */
	signal( SIGQUIT, SIG_DFL );

	sigsetmask( 0 );
	kill( getpid(), SIGQUIT );
	sigpause( 0 );
}

SetFileInfo()
{
	register FINFO *fi;
	register int i;
	register int flags;
	register int scm;

	/*
	dprintf( D_ALWAYS, "Entering SetFileInfo()\n" );
	DumpOpenFds();
	*/

	if( RunningAsCondor ) {
		scm = SetSyscalls( SYS_REMOTE | SYS_UNRECORDED, __LINE__, __FILE__ );
	} else {
		scm = SetSyscalls( SYS_LOCAL | SYS_UNRECORDED, __LINE__, __FILE__ );
	}

	for( i = 0; i < NOFILE; i++ ) {
		fi = &RestartInfo.rr_file[i];
		flags = fi->fi_flags;

		if( (flags & FI_OPEN) != FI_OPEN ) {		/* file not open */
			continue;
		}

		if( (flags & FI_DUP) == FI_DUP ) {			/* dup of some other fd */
			continue;
		}

		if( (flags & FI_WELL_KNOWN) == FI_WELL_KNOWN ) {/* socket to shadow */
			continue;
		}

		if( (fi->fi_flags & FI_NFS) == FI_NFS ) {
			fi->fi_pos = syscall( SYS_lseek, fi->fi_fdno, 0, L_INCR );
		} else {
			fi->fi_pos = REMOTE_syscall( CONDOR_lseek, fi->fi_fdno, 0, L_INCR );
		}
		if( fi->fi_pos == (unsigned)-1 ) {
			dprintf( D_ALWAYS, "errno = %d\n", errno );
			EXCEPT( "lseek(%d,0,L_INCR) = %d", fi->fi_fdno, 0, L_INCR );
		}

		/*
		dprintf( D_ALWAYS, "FD %d->%d: '%s', priv 0%o, flags 0%o, pos %d\n",
		i, fi->fi_fdno, fi->fi_path, fi->fi_priv, fi->fi_flags, fi->fi_pos );
		*/

	}

	/*
	DumpOpenFds();
	*/

		/* close down all remote files */
	for( i = 0; i < NOFILE; i++ ) {
		fi = &RestartInfo.rr_file[i];
		flags = fi->fi_flags;

		if( (flags & FI_OPEN) != FI_OPEN ) {		/* file not open */
			continue;
		}

		if( (flags & FI_DUP) == FI_DUP ) {			/* dup of some other fd */
			continue;
		}

		if( (flags & FI_WELL_KNOWN) == FI_WELL_KNOWN ) {/* socket to shadow */
			continue;
		}

		if( (flags & FI_NFS) == 0 ) {
			if( REMOTE_syscall(CONDOR_close,fi->fi_fdno) < 0 ) {
				EXCEPT( "File %d->%d is open, but can't close", i,fi->fi_fdno);
			}
		}
	}

	(void) SetSyscalls( scm, __LINE__, __FILE__ );
}

ReadStackSize()
{
	register int fd;
	int scm;	/* System call mode (local or remote */
	int	 where;

	/*
	scm = SetSyscalls( SYS_LOCAL | SYS_RECORDED, __LINE__, __FILE__ );
	*/

	fd = open(CkptName, O_RDONLY, 0);
	if( fd < 0 ) {
		EXCEPT( "Could not open '%s', errno = %d",
				CkptName, errno );
	}
	dprintf( D_CKPT, "Opened checkpoint file \"%s\"\n", CkptName );

	if( (where=lseek(fd, -sizeof(StackSize), L_XTND)) < 0 ) {
		EXCEPT("Could not lseek to stack size value");
	}
	dprintf(D_CKPT, "Seeked to %d\n", where );

	if( read(fd, (char *)&StackSize, sizeof(StackSize)) != sizeof(StackSize) ) {
		EXCEPT("Could not read stack size");
	}
	dprintf(D_CKPT, "Read %d bytes\n", sizeof(StackSize) );

	dprintf(D_CKPT, "ReadStackSize: StackSize = %d ntohl(StackSize) = %d\n",
		StackSize, ntohl(StackSize) );

	if( ntohl(StackSize) <= 0 ) {
		EXCEPT( "Stack Size Botch (stack size = %d)\n", ntohl(StackSize) );
	}

	StackSize = ntohl( StackSize );

	close( fd );

	/*
	(void) SetSyscalls( scm, __LINE__, __FILE__ );
	*/
}

extern int	Method;
ReopenFiles()
{
	register FINFO *fi, *dupfi;
	register int i, fd;
	register int flags;
	int		rval;
	int		scm;

	/*
	dprintf( D_ALWAYS, "Before ReopenFiles\n" );
	DumpOpenFds();
	*/

		/* Re-open and restore those files that aren't dup's */
	for( i = 0; i < NOFILE; i++ ) {
		fi = &RestartInfo.rr_file[i];
		flags = fi->fi_flags;

			/* Well known sockets for sending remote system calls or logging
			errors to the shadow.  Don't try to seek on these. */
		if( (flags & FI_WELL_KNOWN) == FI_WELL_KNOWN ) {
			continue;
		}

			/* We're born with these open, just seek to proper place. */
		if( (flags & FI_PREOPEN) == FI_PREOPEN ) {
			if( lseek(i, fi->fi_pos, L_SET) < 0 ) {
				EXCEPT("re-lseek(%d, %d, L_SET)", i, fi->fi_pos);
			}
			continue;
		}

		if( (flags & FI_DUP) == FI_DUP ) {	/* fix these later */
			continue;
		}

		if( (flags & FI_OPEN) == FI_OPEN ) {

			fd = open(fi->fi_path, fi->fi_priv, 0);
			if( fd < 0 ) {
				EXCEPT("open(%s, 0x%x, 0)", fi->fi_path, fi->fi_priv);
			}
			fi->fi_fdno = fd;

			/*
			dprintf( D_ALWAYS, "re-opened \"%s\", %d->%d\n",
											fi->fi_path, i, fi->fi_fdno );
			*/

			if( Method == FI_NFS ) {
				fi->fi_flags |= FI_NFS;
				rval = syscall( SYS_lseek, fd, fi->fi_pos, L_SET );
			} else {
				fi->fi_flags &= ~FI_NFS;
				rval = REMOTE_syscall( CONDOR_lseek, fd, fi->fi_pos, L_SET );
			}
			if( rval != fi->fi_pos ) {
				EXCEPT("lseek(%d,%d,%d) = %d", fd, fi->fi_pos, L_SET, rval );
			}
		}
	}

		/* Now fix up the dups */
	for( i = 0; i < NOFILE; i++ ) {
		fi = &RestartInfo.rr_file[i];
		flags = fi->fi_flags;

		if( (flags & FI_DUP) == FI_DUP ) {
			dupfi = &RestartInfo.rr_file[fi->fi_dupof];
			fi->fi_fdno = dupfi->fi_fdno;
			fi->fi_flags = dupfi->fi_flags | FI_DUP;
		}
	}

	/*
	dprintf( D_ALWAYS, "After ReopenFiles\n" );
	DumpOpenFds();
	*/
}
