#include <stdio.h>
#include "proc_tree.h"

#define THRESHOLD	0.60

PROCESS	ProcTab[4096];
int		N_Procs;

extern int		IgnoreList[256];
extern int		N_Ignore;



NODE *
create_node( pid, state )
int pid;
int state;
{
	NODE *answer;

	answer = (NODE *)malloc( sizeof(NODE) );
	answer->pid = pid;
	answer->state = create_queue();
	add_to_queue( answer->state, (char)state );
	answer->children = create_list();

	return answer;
}



update( tree, fp )
NODE *tree;
FILE *fp;
{
	int		n;
	char	header[256];
	char	buf[256];
	int		i;
	NODE	*p;
	NODE	*parent;
	char	*ptr, *index();


	walk_tree( mark_untouched, tree );
	tree->touched = TRUE;

	fgets( header, sizeof(header), fp ); 	/* Skip column headers */
	N_Procs = 0;
	while( fgets(buf,sizeof(buf),fp) ) {

		if( substr(buf,"swapper") ) {
			continue;
		}

		if( substr(buf,"pagedaemon") ) {
			continue;
		}

		if( substr(buf,"idleproc") ) {
			continue;
		}


#if 0
		printf( "%s", header );
		printf( "%s", buf );
#endif
		n = scan_ps_line( buf, &ProcTab[N_Procs] );

		if( n != 3 ) {
			printf( "**** %s ****", buf );
			continue;
		}

#if defined(DEBUG_PROC_TREE)
		ptr = index(buf,':') + 4;
		strncpy( ProcTab[N_Procs].cmd, ptr, CMD_STR_SIZE - 1 );
		ProcTab[N_Procs].cmd[CMD_STR_SIZE - 1] = '\0';
#endif

		ProcTab[N_Procs].processed = FALSE;
		N_Procs++;
	}


	for( i=0; i<N_Procs; i++ ) {
		if( ProcTab[i].processed ) {
			continue;
		}
		if( p = search_tree(ProcTab[i].pid,tree) ) {
			if( p->parent->pid != ProcTab[i].ppid ) {
				printf( "Process %d has a new parent (%d)\n",
					ProcTab[i].pid, ProcTab[i].ppid );

				parent = search_tree( ProcTab[i].ppid, tree );
				if( parent == NULL ) {
					printf( "Can't find new parent though - skipping\n" );
				} else {
					delete_from_list( p );
					add_to_list( p, parent->children );
				}
			}
			add_to_queue( p->state, ProcTab[i].state );
			p->touched = TRUE;
		} else {
			insert_proc( &ProcTab[i], tree );
		}
	}

	walk_tree( delete_terminated_procs, tree );
	printf( "Update done\n" );

}

void
insert_proc( proc, tree )
PROCESS *proc;
NODE *tree;
{
	NODE	*parent_node;
	PROCESS	*parent_proc;
	NODE	*new;
	char	*strdup();

	if( proc->processed ) {
		return;
	}

	parent_node = search_tree( proc->ppid, tree );
	if( parent_node == NULL ) {
		parent_proc = search_tab( proc->ppid );
		if( parent_proc ) {
			insert_proc( parent_proc, tree );
			parent_node = search_tree( proc->ppid, tree );
		} else {
			printf( "Skipped %d\n", proc->pid );
			return;
		}
	}

	new = create_node( proc->pid, proc->state );
	new->parent = parent_node;
	new->touched = TRUE;
#if defined( DEBUG_PROC_TREE )
	new->cmd = strdup( proc->cmd );
#endif
	add_to_list( new, parent_node->children );
	proc->processed = TRUE;
}

PROCESS *
search_tab( pid )
int pid;
{
	int		i;

	for( i=0; i<N_Procs; i++ ) {
		if( ProcTab[i].pid == pid ) {
			return &ProcTab[i];
		}
	}
	return NULL;
}


NODE *
search_tree( pid, tree )
int pid;
NODE *tree;
{
	NODE	*ptr;
	NODE	*answer;

	if( pid == tree->pid ) {
		return tree;
	}

	for( ptr = tree->children->next; ptr->pid != DUMMY; ptr = ptr->next ) {
		if( answer = search_tree(pid,ptr) ) {
			return answer;
		}
	}
	return NULL;
}


void
add_to_queue( q, val )
QUEUE *q;
int val;
{
	q->data[q->last] = (char)val;
	q->last = (q->last + 1) % QUEUE_SIZE;
	if( q->last == q->first ) {
		q->first = (q->first + 1) % QUEUE_SIZE;
	}
}

void
display_queue( q )
QUEUE *q;
{
	int		i;

	printf( "[ " );
	for( i = q->first; i != q->last; i = (i + 1) % QUEUE_SIZE ) {
		printf( "%c ", q->data[i] );
	}
	printf( "]" );
}


NODE *
create_tree()
{
	NODE	*answer;

	answer = (NODE *)malloc( sizeof(NODE) );
	answer->pid = 0;
	answer->state = create_queue();
	answer->parent = answer;
	answer->children = create_list();
	return answer;
}

void
display_node( n, level )
NODE *n;
int level;
{
	int		i;
	NODE	*ptr;

	for( i=0; i<level; i++ ) {
		printf( "    " );
	}

	printf( "%d", n->pid );
	display_queue( n->state );

#if 0
	if( n->touched ) {
		printf( "(Touched)" );
	} else {
		printf( "(Not Touched)" );
	}
#endif
	printf( "\n" );

	for( ptr = n->children->next; ptr->pid != DUMMY; ptr = ptr->next ) {
		display_node( ptr, level + 1 );
	}
	
}

QUEUE *
create_queue()
{
	QUEUE	*answer;

	answer = (QUEUE *)malloc( sizeof(QUEUE) );
	answer->first = answer->last = 0;
	return answer;
}

void
add_to_list( new, list )
NODE *new;
NODE *list;
{
	new->next = list;
	new->prev = list->prev;
	list->prev->next = new;
	list->prev = new;
}

void
delete_from_list( p )
NODE *p;
{
	p->next->prev = p->prev;
	p->prev->next = p->next;
}


NODE *
create_list()
{
	NODE *answer;

	answer = (NODE *)malloc( sizeof(NODE) );
	answer->pid = DUMMY;
	answer->next = answer;
	answer->prev = answer;
	answer->parent = NULL;
	answer->children = NULL;

	return answer;
}

void
delete_terminated_procs( n )
NODE *n;
{
	if( n->touched == FALSE ) {
		delete_from_list( n );
	}
}

int
is_ancestor( pid, node )
int pid;
NODE *node;
{
	NODE	*ptr;

	for( ptr = node; ptr; ptr = ptr->parent ) {
		if( ptr->pid == pid ) {
			return TRUE;
		}
		if( ptr->pid == 0 ) {
			return FALSE;
		}
	}
	return FALSE;
}

void
find_active( n )
NODE *n;
{
	QUEUE	*q;
	int		i;
	int		active = 0;
	int		n_values = 0;
	double	avg;

	for( i=0; i<N_Ignore; i++ ) {
		if( is_ancestor(IgnoreList[i],n) ) {
			return;
		}
	}

	q = n->state;
	for( i = q->first; i != q->last; i = (i + 1) % QUEUE_SIZE ) {
		if( q->data[i] == 'R' || q->data[i] == 'D' ) {
			active += 1;
		}
		n_values += 1;
	}
	if( n_values < 4 ) {	/* not enough data to make decision */
		return;
	}

	avg = (double)active / (double)n_values;
	if( avg >= THRESHOLD ) {
		printf( "Process %d is active ", n->pid  );
		display_queue( q );
#if defined( DEBUG_PROC_TREE )
		printf( " %s", n->cmd );
#endif
		printf( "\n" );
	}
}

void
mark_untouched( n )
NODE *n;
{
	n->touched = FALSE;
}


void
walk_tree( func, n )
#if defined(HAS_PROTO)
void func(NODE *);
#else
void	(*func)();
#endif
NODE *n;
{
	NODE	*ptr;

	func( n );

	for( ptr = n->children->next; ptr->pid != DUMMY; ptr = ptr->next ) {
		walk_tree( func, ptr );
	}
	
}

#if defined(AIX32)
int
scan_ps_line( line,  proc )
char line[];
PROCESS *proc;
{
	int		n_matches;

	n_matches = sscanf( line,
		"\n%*s %c %*s %d %d %*s %*s %*s %*s %*s %*s %*s %*s %*s",
		&proc->state, &proc->pid, &proc->ppid );

	return n_matches;
}
#endif

#if defined(ULTRIX42) || defined(SUNOS41)
int
scan_ps_line( line,  proc )
char line[];
PROCESS *proc;
{
	char	*ptr;
	int		n_matches;

	n_matches = sscanf( line,
		"\n %*8s %*s %d %5d %*s %*s %*s %*4s %*s %*s %*s %c %*s %*s",
		&proc->pid, &proc->ppid, &proc->state );
	for( ptr = line; *ptr; ptr++ ) {
		if( isupper(*ptr) ) {
			ProcTab[N_Procs].state = *ptr;
			break;
		}
	}

	return n_matches;
}
#endif
