/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Author:  Michael J. Litzkow
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 

/* $Header:syscall.h 12.0$ */
/* $ACIS:syscall.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/syscall.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsyscall = "$Header:syscall.h 12.0$";
#endif

#define VFS

/*
** These system calls are all specific to AIX3  Just assign numbers out
** of the normal range of berkeley system calls.
*/
#define SYS_accessx		901
#define SYS_audit		902
#define SYS_auditbin	903
#define SYS_auditevents	904
#define SYS_auditlog	905
#define SYS_auditobj	906
#define SYS_auditproc	907
#define SYS_brk			964
#define SYS_chacl		908
#define SYS_chownx		909
#define SYS_chpriv		910
#define SYS_disclaim	911
#define SYS_faccessx	912
#define SYS_fchacl		913
#define SYS_fchownx		914
#define SYS_fchpriv		915
#define SYS_fclear		916
#define SYS_frevoke		917
#define SYS_fscntl		918
#define SYS_fstatacl	919
#define SYS_fstatpriv	920
#define SYS_fstatx		921
#define SYS_getargs		922
#define SYS_getdirent	923
#define SYS_getevars	924
#define SYS_getgidx		925
#define SYS_kgetpgrp	926
#define SYS_getpri		927
#define SYS_getpriv		928
#define SYS_getproc		929
#define SYS_getuidx		930
#define SYS_getuser		931
#define SYS_kfcntl		932
#define SYS_kioctl		933
#define SYS_knlist		934
#define SYS_kreadv		935
#define SYS_kwaitpid	936
#define SYS_kwritev		937
#define SYS_load		938
#define SYS_loadbind	939
#define SYS_loadquery	940
#define SYS_mntctl		941
#define SYS_openx		942
#define SYS_pause		943
#define SYS_plock		944
#define SYS_poll		945
#define SYS_privcheck	946
#define SYS_psdanger	947
#define SYS_revoke		948
#define SYS_absinterval	949
#define SYS_getinterval	950
#define SYS_gettimer	951
#define SYS_gettimerid	952
#define SYS_incinterval	953
#define SYS_reltimerid	954
#define SYS_resabs		955
#define SYS_resinc		956
#define SYS_restimer	957
#define SYS_settimer	958
#define SYS_nsleep		959
#define SYS_seteuid		960
#define SYS_setgid		961
#define SYS_setgidx		962
#define SYS_setpgid		963
#define SYS_setpri		965
#define SYS_setpriv		966
#define SYS_setsid		967
#define SYS_setuid		968
#define SYS_setuidx		969
#define SYS_shmctl		970
#define SYS_shmget		971
#define SYS_shmat		972
#define SYS_shmdt		973
#define SYS_msgctl		974
#define SYS_msgget		975
#define SYS_msgsnd		976
#define SYS_msgrcv		977
#define SYS_msgxrcv		978
#define SYS_semctl		979
#define SYS_semget		980
#define SYS_semop		981
#define SYS_sigaction	982
#define SYS_sigcleanup	983
#define SYS_sigprocmask	984
#define SYS_sigsuspend	986
#define SYS_sigpending	987
#define SYS_statacl		988
#define SYS_statpriv	989
#define SYS_statx		990
#define SYS_swapoff		991
#define SYS_swapqry		992
#define SYS_sysconfig	993
#define SYS_times		994
#define SYS_ulimit		995
#define SYS_uname		996
#define SYS_unameu		997
#define SYS_unamex		998
#define SYS_unload		999
#define SYS_usrinfo		1000
#define SYS_ustat		1001
#define SYS_uvmount		1002
#define SYS_vmount		1003
#define SYS_Trconflag	1004
#define SYS_trchook		1005
#define SYS_trchk		1006
#define SYS_trchkt		1007
#define SYS_trchkl		1008
#define SYS_trchklt		1009
#define SYS_trchkg		1010
#define SYS_trchkgt		1011
#define SYS_trcgen		1012
#define SYS_trcgent		1013
#define SYS_getppid		1014
#define SYS_lockf		1015





/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)syscall.h	5.4 (Berkeley) 4/3/86
 */

#define	SYS_syscall	0
#define	SYS_exit	1
#define	SYS_fork	2
#define	SYS_read	3
#define	SYS_write	4
#define	SYS_open	5
#define	SYS_close	6
				/*  7 is old: wait */
#define	SYS_creat	8
#define	SYS_link	9
#define	SYS_unlink	10
#define	SYS_execv	11
#define	SYS_chdir	12
				/* 13 is old: time */
#define	SYS_mknod	14
#define	SYS_chmod	15
#define	SYS_chown	16
				/* 17 is old: sbreak */
				/* 18 is old: stat */
#define	SYS_lseek	19
#define	SYS_getpid	20
#ifndef VFS
#define	SYS_mount	21
#else /* !VFS */
				/* 21 is old: mount */
#endif
#define	SYS_umount	22	
				/* 23 is old: setuid */
#define	SYS_getuid	24
				/* 25 is old: stime */
#define	SYS_ptrace	26
				/* 27 is old: alarm */
				/* 28 is old: fstat */
				/* 29 is old: pause */
				/* 30 is old: utime */
				/* 31 is old: stty */
				/* 32 is old: gtty */
#define	SYS_access	33
				/* 34 is old: nice */
				/* 35 is old: ftime */
#define	SYS_sync	36
#define	SYS_kill	37
#define	SYS_stat	38
				/* 39 is old: setpgrp */
#define	SYS_lstat	40
#define	SYS_dup		41
#define	SYS_pipe	42
				/* 43 is old: times */
#define	SYS_profil	44
				/* 45 is unused */
				/* 46 is old: setgid */
#define	SYS_getgid	47
				/* 48 is old: sigsys */
				/* 49 is unused */
				/* 50 is unused */
#define	SYS_acct	51
				/* 52 is old: phys */
				/* 53 is old: syslock */
#define	SYS_ioctl	54
#define	SYS_reboot	55
				/* 56 is old: mpxchan */
#define	SYS_symlink	57
#define	SYS_readlink	58
#define	SYS_execve	59
#define	SYS_umask	60
#define	SYS_chroot	61
#define	SYS_fstat	62
				/* 63 is unused */
#define	SYS_getpagesize 64
#define	SYS_mremap	65
#define	SYS_vfork	66  /* 66 is old: vfork */
				/* 67 is old: vread */
				/* 68 is old: vwrite */
#define	SYS_sbrk	69
#define	SYS_sstk	70
#define	SYS_mmap	71
#define	SYS_vadvise	72  /* 72 is old: vadvise */
#define	SYS_munmap	73
#define	SYS_mprotect	74
#define	SYS_madvise	75
/*
#define	SYS_vhangup	76
*/
				/* 77 is old: vlimit */
#define	SYS_mincore	78
#define	SYS_getgroups	79
#define	SYS_setgroups	80
#define	SYS_getpgrp	81
#define	SYS_setpgrp	82
#define	SYS_setitimer	83
#define	SYS_wait	84
#define	SYS_swapon	85
#define	SYS_getitimer	86
#define	SYS_gethostname	87
#define	SYS_sethostname	88
#define	SYS_getdtablesize 89
#define	SYS_dup2	90
#define	SYS_getdopt	91
#define	SYS_fcntl	92
#define	SYS_select	93
#define	SYS_setdopt	94
#define	SYS_fsync	95
#define	SYS_setpriority	96
#define	SYS_socket	97
#define	SYS_connect	98
#define	SYS_accept	99
#define	SYS_getpriority	100
#define	SYS_send	101
#define	SYS_recv	102
#define	SYS_sigreturn	103
#define	SYS_bind	104
#define	SYS_setsockopt	105
#define	SYS_listen	106
				/* 107 was vtimes */
#define	SYS_sigvec	108
#define	SYS_sigblock	109
#define	SYS_sigsetmask	110
#define	SYS_sigpause	111
#define	SYS_sigstack	112
#define	SYS_recvmsg	113
#define	SYS_sendmsg	114
				/* 115 is old vtrace */
#define	SYS_gettimeofday 116
#define	SYS_getrusage	117
#define	SYS_getsockopt	118
				/* 119 is old resuba */
#define	SYS_readv	120
#define	SYS_writev	121
#define	SYS_settimeofday 122
#define	SYS_fchown	123
#define	SYS_fchmod	124
#define	SYS_recvfrom	125
#define	SYS_setreuid	126
#define	SYS_setregid	127
#define	SYS_rename	128
#define	SYS_truncate	129
#define	SYS_ftruncate	130
#define	SYS_flock	131
				/* 132 is unused */
#define	SYS_sendto	133
#define	SYS_shutdown	134
#define	SYS_socketpair	135
#define	SYS_mkdir	136
#define	SYS_rmdir	137
#define	SYS_utimes	138
				/* 139 is unused */
#define	SYS_adjtime	140
#define	SYS_getpeername	141
#define	SYS_gethostid	142
#define	SYS_sethostid	143
#define	SYS_getrlimit	144
#define	SYS_setrlimit	145
#define	SYS_killpg	146
				/* 147 is unused */
#define	SYS_setquota	148
#define	SYS_quota	149
#define	SYS_getsockname	150
#define	SYS_exect	151
#define	SYS_getfpemulator 153
#if defined(AFS) || defined(VICE)
#define	SYS_iopen	154		/* AFS_SERVER */
#define	SYS_iread	155		/* AFS_SERVER */
#define	SYS_iwrite	156		/* AFS_SERVER */
#define	SYS_iinc	157		/* AFS_SERVER */
#define	SYS_idec	158		/* AFS_SERVER */
#endif /* AFS */
#ifdef VICE
#define	SYS_pioctl	159		/* VICE */
#define	SYS_setpag	160		/* VICE */
#else /* VICE */
#ifdef AFS
#define SYS_afs_pioctl	159		/* AFS */
#define SYS_afs_setpag	160		/* AFS */
#endif /* AFS */
#endif /* VICE */
#define	SYS_vdspin	161		/* RVD */
#define	SYS_vdspind	162		/* RVD */
#define	SYS_vdstats	163		/* RVD */
#define	SYS_syscalltrace 164		/* SYSCALLTRACE */
#define	SYS_icreate	165		/* AFS_SERVER */
			/* 166 is unused adjtime */
#define	SYS_getfloatstate 167		/* getfloatstate */
#define	SYS_setfloatstate 168		/* setfloatstate */

#ifdef VFS
#ifdef NFS
#define SYS_nfssvc		169
#endif /* NFS */
/*
#define SYS_getdirentries	170
*/
#define SYS_statfs		171
#define SYS_fstatfs		172
#define SYS_unmount		173
#ifdef NFS
#define SYS_async_daemon	174
#define SYS_getfh		175
#endif /* NFS */
#define SYS_getdomainname	176
#define SYS_setdomainname	177
#define SYS_quotactl		178
#ifdef NFS
#define SYS_exportfs		179
#endif /* NFS */
#define SYS_mount		180
#endif /* VFS */
#ifdef AFS
#define SYS_afs_test		181
#endif /* AFS */

#define SYS__exit		SYS_exit
#define SYS__load		SYS_load
