#define DEBUG_PROC_TREE


#if defined( DEBUG_PROC_TREE )
#define CMD_STR_SIZE 30
#endif

#if defined(AIX32) || defined(ULTRIX42)
#define HAS_PROTO
#endif

#if defined(AIX32)
#define	PS_CMD "ps -el"
#endif

#if defined( ULTRIX42 ) || defined(SUNOS41)
#define	PS_CMD "ps -axlww"
#endif

#define QUEUE_SIZE	8
#define DUMMY -1
#define MATCH 0		/* indicates matching strcmp() */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

typedef struct {
	char	data[ QUEUE_SIZE ];
	int		first;
	int		last;
} QUEUE;

typedef struct node {
	int		pid;
	QUEUE	*state;
	int		touched;
#if defined(DEBUG_PROC_TREE)
	char	*cmd;
#endif
	struct node	*parent;
	struct node	*children;
	struct node	*next;
	struct node	*prev;
} NODE;


typedef struct {
	int		pid;
	int		ppid;
	char	state;
	int		processed;
#if defined(DEBUG_PROC_TREE)
	char	cmd[CMD_STR_SIZE];
#endif
} PROCESS;


#if defined(HAS_PROTO)
void	insert_proc( PROCESS *, NODE * );
void	add_to_queue( QUEUE *q, int val );
void	display_node( NODE *n, int level );
void	add_to_list( NODE *new, NODE *list );
void	delete_from_list( NODE *p );
void	walk_tree( void func(NODE *), NODE *tree );
void	mark_untouched( NODE *n );
void	delete_terminated_procs( NODE *n );
void	find_active( NODE *n );
PROCESS	*search_tab( int pid );
NODE	*search_tree( int pid, NODE *tree );
NODE	*create_node( int pid, int state );
NODE	*create_tree();
NODE	*create_list();
QUEUE	*create_queue();
#else
void	insert_proc();
void	add_to_queue();
void	display_node();
void	add_to_list();
void	delete_from_list();
void	walk_tree();
void	mark_untouched();
void	delete_terminated_procs();
void	find_active();
PROCESS	*search_tab();
NODE	*search_tree();
NODE	*create_node();
NODE	*create_tree();
NODE	*create_list();
QUEUE	*create_queue();
#endif

