/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/file.h>
#include <stdio.h>

#include "debug.h"
extern int DebugFlags;
extern int Syscalls;
extern int AvoidNFS;


main( argc, argv )
int argc;
char **argv;
{
	int i, j;
	register int k;
	char buf[ 1024 ];
	int fd;
	FILE	*fp;
	extern char Condor_CWD[];
	char *curbrk, *oldbrk, *sbrk();

	/*
	DebugFlags = D_CKPT;
	*/

	if( (fp=fopen( "results", "w" )) == NULL ) {
		perror( "results" );
		exit( 1 );
	}

	oldbrk = sbrk(0);

	for( i = 0; i < 2; i++ ) {
		sprintf(buf, "set i = %d\n", i);
		write( 2, buf, strlen(buf) );

		rewind( fp );
		fprintf( fp, "set i = %d\n", i );
		fflush( fp );


		curbrk = sbrk(0);
		if( oldbrk != curbrk ) {
			sprintf(buf, "Current break is now 0x%x, old was 0x%x\n",
				curbrk, oldbrk);
			write( 2, buf, strlen(buf) );
		}

		oldbrk = curbrk;

		for(k=j=0; j < 100000; k++,j++ );
		if( j != k ) {
			sprintf(buf, "j = %d, k (register) = %d\n", j, k);
			write( 2, buf, strlen(buf) );
		}

		AvoidNFS = 1;
		ckpt();
		/*
		*/
	}
	exit( 0 );
}

loop(){};
