#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <errno.h>

extern int	AvoidNFS;

struct fd_rec {
	int		fd;
	off_t	eof;
};

struct fd_rec	Fd_Rec[256];
int		N_Fd_Recs;



main( argc, argv )
int		argc;
char	*argv[];
{
	int		i, fd;

	check_close( 15 );
	check_close( 16 );
	check_close( 17 );
	check_close( 18 );
	check_close( 19 );
	check_close( 20 );

	for( i=1; i<argc; i++ ) {
		if( (fd=open(argv[i],O_RDONLY,0)) < 0 ) {
			fprintf( stderr, "Can't open \"%s\"\n", argv[i] );
			exit( 1 );
		}
		/*
		printf( "Opened \"%s\" as fd %d\n", argv[i], fd );
		*/
		init_fd_rec( fd );
	}
	printf( "Opened %d files\n", i-1 );
	fflush( stdout );

	AvoidNFS = 1;
	printf( "About to checkpoint\n" );
	fflush( stdout );
	ckpt();
	printf( "Returned from checkpoint\n" );
	fflush( stdout );
	check_fd_recs();

	AvoidNFS = 0;
	printf( "About to checkpoint\n" );
	fflush( stdout );
	ckpt();
	printf( "Returned from checkpoint\n" );
	fflush( stdout );
	check_fd_recs();

	printf( "Normal End of Job\n" );
	exit( 0 );
}

init_fd_rec( fd )
int		fd;
{
	off_t			end;
	struct fd_rec	*fd_rec;

	end = lseek( fd, 0, 2 );
	fd_rec = &Fd_Rec[ N_Fd_Recs ];
	fd_rec->fd = fd;
	fd_rec->eof = end;
	N_Fd_Recs += 1;
	/*
	printf( "Eof = %d\n", end );
	*/
}

check_fd_recs()
{
	int				i;
	struct fd_rec	*fd_rec;
	off_t			cur, end;

	for( i=0; i<N_Fd_Recs; i++ ) {
		fd_rec = &Fd_Rec[ i ];
		cur = lseek( fd_rec->fd, 0, 1 );
		end = lseek( fd_rec->fd, 0, 2 );
		if( cur != end ) {
			printf( "ERROR on fd %d, cur = %d, end = %d\n", i, cur, end );
			exit( 1 );
		}
		if( end != fd_rec->eof ) {
			printf( "ERROR end = %d, previously was %d\n", end, fd_rec->eof );
			exit( 1 );
		}
	}
	printf( "OK\n" );
}

extern int	errno;
check_close( fd )
int		fd;
{
	int	status;
	status = close( fd );
	if( status >= 0 || errno != EBADF ) {
		printf( "Error: close(%d) = %d, errno = %d\n", fd, status, errno );
		exit( 1 );
	}
}
