/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <sys/types.h>
#include <sys/param.h>
#include "condor_sys.h"
#include "ckpt_file.h"
#include <sys/uio.h>

extern int	Syscalls;
extern RESTREC	RestartInfo;

#if !defined(IRIX405)
writev( fd, iov, iovcnt )
int fd;
struct iovec *iov;
int iovcnt;
{
	int rval;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];

	fd = map_fd( fd );		/* Map user fd to physical fd */

	if( fd < 0 ) {		/* file wasn't open */
		return -1;
	}

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_writev, fd, iov, iovcnt );
	} else {
		rval = fake_writev( fd, iov, iovcnt );
	}

	return( rval );
}
#endif

/*
** Handle a call to writev which must be done remotely, (not NFS).  Note
** the user file descriptor has already been mapped by the calling routine,
** and we already know this is a remote system call.  We handle the call
** by breaking it up into a series of remote writes.
*/
static
fake_writev( fd, iov, iovcnt )
int fd;
struct iovec *iov;
int iovcnt;
{
	register int i, rval = 0, cc;

	for( i = 0; i < iovcnt; i++ ) {
		cc = REMOTE_syscall( CONDOR_write, fd, iov->iov_base, iov->iov_len );
		if( cc < 0 ) {
			break;
		}

		rval += cc;
		if( cc != iov->iov_len ) {
			break;
		}

		iov++;
	}

	return( rval );
}
