/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include "debug.h"
#include "except.h"
static char *_FileName_ = __FILE__;		/* Used by EXCEPT (see except.h)     */

#if defined(AIX31) || defined(AIX32)
#include <sys/mntctl.h>
#include <sys/vmount.h>
#include <sys/sysmacros.h>
#define NMOUNT  256
#endif

#if defined(IRIX405)
#define NMOUNT 256  /* I haven't a clue as to what this should be -- mike */
#endif

#if defined(ULTRIX) || defined(ULTRIX42)
#include <sys/mount.h>
#else
struct fs_data_req {
	dev_t	dev;
	char	*devname;
	char	*path;
};
struct fs_data {
	struct fs_data_req fd_req;
};
#define NOSTAT_MANY 0
#endif

#if !defined(ULTRIX) && !defined(ULTRIX42) && !defined(AIX31) && !defined(AIX32)
#include <mntent.h>
#endif

#if	NMOUNT < 256
#undef	NMOUNT
#define	NMOUNT	256		/* SunOS 4.1.2 makes it only 40 */
#endif	/* NMOUNT < 256 */

#define TRUE 	1
#define FALSE	0

char			*index(), *strdup(), *substr();

static struct fs_data	FS_Buf[ NMOUNT ];
static int				N_Sys;
static int				InitDone;

/*
** Given an external name of the form <machine>:<pathname>, translate
** this to an internally valid pathname to the file.  If there is no
** access to the file from this machine, return NULL.
*/
char	*
internal_name( name )
char	*name;
{
	int					i;
	char				*ptr;
	static char			buf[MAXPATHLEN + 1];
	struct fs_data_req	*fs;

	dprintf( D_FULLDEBUG, "Entering internal_name(%s)\n", name );

	if( !InitDone ) {
		init();
	}

	for( i=0; i < N_Sys; i++ ) {
		fs = &FS_Buf[i].fd_req;
		dprintf( D_FULLDEBUG, "devname=%s\n", fs->devname );
		/* Now check if "fs->devname" is either equal to "name",
		 * or a _directory_ (!) prefix of it.
		 */
		if( (ptr=substr(fs->devname,name))
			&& (*ptr == '/' || !*ptr) ) {
			strcpy( buf, fs->path );
			strcat( buf, ptr );
			dprintf( D_FULLDEBUG,
				"Internal_name returning \"%s\"\n", buf );
			return strdup( buf );
		}
	}
	dprintf( D_FULLDEBUG, "Internal_name returning NULL\n" );
	return NULL;
}

static
init()
{
	int		start = 0;
	char	hostname[512];
	int		i;
	struct fs_data_req	*fs;

	dprintf( D_FULLDEBUG, "At line %d in %s\n", __LINE__, __FILE__ );
	/*
	display_syscall_mode( __LINE__, __FILE__ );
	*/

	if( (N_Sys=getmnt(&start,FS_Buf,sizeof(FS_Buf),NOSTAT_MANY,0)) < 0 ) {
		EXCEPT( "getmnt failed" );
	}
	dprintf( D_FULLDEBUG, "At line %d in %s\n", __LINE__, __FILE__ );
	dprintf( D_FULLDEBUG, "N_Sys=%d\n", N_Sys );

	if( gethostname(hostname,sizeof(hostname)) < 0 ) {
		EXCEPT( "gethostname failed\n" );
	}
	dprintf( D_FULLDEBUG, "At line %d in %s\n", __LINE__, __FILE__ );

	for( i=0; i < N_Sys; i++ ) {
		fs = &FS_Buf[i].fd_req;
		if( index(fs->devname,':') == NULL ) {
			/* local (physical) device */
			free( fs->devname );
			if( (fs->devname = malloc( strlen(hostname) +
				strlen(fs->path) + 2 )) == NULL ) {
				EXCEPT( "malloc failed" );
			}
			sprintf( fs->devname, "%s:%s", hostname, fs->path );
		}
	}
	dprintf( D_FULLDEBUG, "At line %d in %s\n", __LINE__, __FILE__ );

	InitDone = TRUE;
}

static char	*
substr( targ, str )
char	*targ;
char	*str;
{
	while( *targ == *str ) {
		targ++;
		str++;
	}

	if( *targ == '\0' ) {
		return str;
	} else {
		return NULL;
	}
}
