/* 
** Copyright 1986, 1987, 1988, 1989, 1990, 1991 by the Condor Design Team
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the names of the University of
** Wisconsin and the Condor Design Team not be used in advertising or
** publicity pertaining to distribution of the software without specific,
** written prior permission.  The University of Wisconsin and the Condor
** Design Team make no representations about the suitability of this
** software for any purpose.  It is provided "as is" without express
** or implied warranty.
** 
** THE UNIVERSITY OF WISCONSIN AND THE CONDOR DESIGN TEAM DISCLAIM ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE UNIVERSITY OF
** WISCONSIN OR THE CONDOR DESIGN TEAM BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
** 
** Authors:  Allan Bricker and Michael J. Litzkow,
** 	         University of Wisconsin, Computer Sciences Dept.
** 
*/ 


#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "condor_sys.h"
#include "ckpt_file.h"
#include "debug.h"

extern int	Syscalls;
extern RESTREC	RestartInfo;

read( fd, buf, nbytes )
int fd;
char *buf;
int nbytes;
{
	int rval;
	int	orig;
	register FINFO *fi = &RestartInfo.rr_file[ fd ];


	orig = fd;
	fd = map_fd( fd );      /* Map user fd to physical fd */
	dprintf( D_FULLDEBUG, "read( %d->%d )\n", orig, fd );

	if( fd < 0 ) {		/* file wasn't open */
		dprintf( D_ALWAYS, "read(%d->%d, 0x%x,%d): file not open\n",
			orig, fd, buf, nbytes );
		return -1;
	}

	if( (Syscalls & SYS_LOCAL) || (fi->fi_flags & FI_NFS) ) {
		rval = syscall( SYS_read, fd, buf, nbytes );
	} else {
		rval = REMOTE_syscall( CONDOR_read, fd, buf, nbytes );
	}

	dprintf( D_FULLDEBUG, "read() returns %d\n", rval );
	return( rval );
}

#ifdef NOTDEF
/*
** Arrange to die with a full core dump.
*/
my_abort()
{
	(void) SetSyscalls( SYS_LOCAL | SYS_UNRECORDED, __LINE__, __FILE__ );
	dprintf( D_ALWAYS, "abort() Called\n" );
	display_syscall_mode( __LINE__, __FILE__ );


	signal( SIGQUIT, SIG_DFL );
	limit( RLIMIT_CORE, RLIM_INFINITY );

	sigsetmask( 0 );
	kill( getpid(), SIGQUIT );
	sigpause( 0 );
}
#endif
